/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.InjectionPointFactory;
import jodd.petite.SetInjectionPoint;
import jodd.petite.meta.PetiteInject;
import jodd.util.ReflectUtil;

public class SetResolver {
    protected final Map<Class, SetInjectionPoint[]> collections = new HashMap<Class, SetInjectionPoint[]>();
    protected final InjectionPointFactory injectionPointFactory;

    public SetResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public SetInjectionPoint[] resolve(Class type, boolean autowire) {
        Field[] allFields;
        SetInjectionPoint[] fields = this.collections.get(type);
        if (fields != null) {
            return fields;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<SetInjectionPoint> list = new ArrayList<SetInjectionPoint>();
        for (Field field : allFields = cd.getAllFields(true)) {
            Class<?> fieldType;
            PetiteInject ref = field.getAnnotation(PetiteInject.class);
            if (!autowire && ref == null || (fieldType = field.getType()) != Collection.class && !ReflectUtil.isSubclass(fieldType, Collection.class)) continue;
            list.add(this.injectionPointFactory.createSetInjectionPoint(field));
        }
        fields = list.isEmpty() ? SetInjectionPoint.EMPTY : list.toArray(new SetInjectionPoint[list.size()]);
        this.collections.put(type, fields);
        return fields;
    }

    public void remove(Class type) {
        this.collections.remove(type);
    }
}

