/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.log.Log;
import jodd.petite.BeanDefinition;
import jodd.petite.InitMethodPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteRegistry;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.SetInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.config.PetiteConfigurator;
import jodd.petite.scope.SingletonScope;
import jodd.typeconverter.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetiteContainer
extends PetiteRegistry {
    private static final Log log = Log.getLogger(PetiteContainer.class);
    public static final String PETITE_CONTAINER_REF_NAME = "petiteContainer";

    public PetiteContainer() {
        this(new PetiteConfig());
    }

    public PetiteContainer(PetiteConfig config) {
        super(config);
        if (log.isDebugEnabled()) {
            log.debug("Petite container created.");
        }
    }

    public void configure(PetiteConfigurator ... petiteConfigurators) {
        for (PetiteConfigurator petiteConfigurator : petiteConfigurators) {
            petiteConfigurator.configure(this);
        }
    }

    protected Object newBeanInstance(BeanDefinition def, Map<String, Object> acquiredBeans) {
        Object bean;
        if (def.ctor == null) {
            def.ctor = this.resolveCtorInjectionPoint(def.type);
        }
        if (def.name != null) {
            acquiredBeans.put(def.name, Void.TYPE);
        }
        int paramNo = def.ctor.references.length;
        Object[] args = new Object[paramNo];
        if (def.wiringMode != WiringMode.NONE) {
            for (int i = 0; i < paramNo; ++i) {
                args[i] = this.getBean(def.ctor.references[i], acquiredBeans);
                if (args[i] != null || def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring constructor failed. Reference '" + def.ctor.references[i] + "' not found for constructor '" + def.ctor.constructor + "'.");
            }
        }
        try {
            bean = def.ctor.constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new PetiteException("Unable to create new bean instance '" + def.type.getName() + "' using constructor: '" + def.ctor.constructor + "'.", ex);
        }
        if (def.name != null) {
            acquiredBeans.put(def.name, bean);
        }
        return bean;
    }

    protected void wireBean(Object bean, BeanDefinition def, Map<String, Object> acquiredBeans) {
        if (def.wiringMode == WiringMode.NONE) {
            return;
        }
        this.wireFields(bean, def, acquiredBeans);
        this.wireMethods(bean, def, acquiredBeans);
    }

    protected void wireFields(Object bean, BeanDefinition def, Map<String, Object> acquiredBeans) {
        if (def.properties == null) {
            def.properties = this.resolvePropertyInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        for (PropertyInjectionPoint pip : def.properties) {
            String[] refName = pip.reference;
            Object value = this.getBean(refName, acquiredBeans);
            if (value == null) {
                if (def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + Convert.toString((Object)refName) + "' not found for property '" + def.type.getName() + '#' + pip.field.getName() + "'.");
            }
            BeanUtil.setDeclaredProperty((Object)bean, (String)pip.field.getName(), (Object)value);
        }
        if (def.sets == null) {
            def.sets = this.resolveCollectionInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        for (SetInjectionPoint sip : def.sets) {
            String[] beanNames = this.resolveBeanNamesForType(sip.targetClass);
            Collection beans = sip.createSet(beanNames.length);
            for (String beanName : beanNames) {
                if (beanName.equals(def.name)) continue;
                Object value = this.getBean(beanName, acquiredBeans);
                beans.add(value);
            }
            BeanUtil.setDeclaredProperty((Object)bean, (String)sip.field.getName(), beans);
        }
    }

    protected void wireMethods(Object bean, BeanDefinition def, Map<String, Object> acquiredBeans) {
        if (def.methods == null) {
            def.methods = this.resolveMethodInjectionPoint(def.type);
        }
        for (MethodInjectionPoint methodRef : def.methods) {
            String[][] refNames = methodRef.references;
            Object[] args = new Object[refNames.length];
            for (int i = 0; i < refNames.length; ++i) {
                String[] refName = refNames[i];
                args[i] = this.getBean(refName, acquiredBeans);
                if (args[i] != null || def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + Convert.toString((Object)refName) + "' not found for method '" + def.type.getName() + '#' + methodRef.method.getName() + "()'.");
            }
            try {
                methodRef.method.invoke(bean, args);
            }
            catch (Exception ex) {
                throw new PetiteException(ex);
            }
        }
    }

    protected void invokeInitMethods(Object bean, BeanDefinition def, Boolean fireFirstOff) {
        if (def.initMethods == null) {
            def.initMethods = this.resolveInitMethods(bean);
        }
        for (InitMethodPoint initMethod : def.initMethods) {
            if (fireFirstOff != null && fireFirstOff != initMethod.firstOff) continue;
            try {
                initMethod.method.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to invoke init method: " + initMethod, ex);
            }
        }
    }

    protected void injectParams(Object bean, BeanDefinition def) {
        if (def.params == null) {
            def.params = this.resolveBeanParams(def.name, this.petiteConfig.getResolveReferenceParameters());
        }
        int len = def.name.length() + 1;
        for (String param : def.params) {
            Object value = this.getParameter(param);
            String destination = param.substring(len);
            try {
                BeanUtil.setDeclaredProperty((Object)bean, (String)destination, (Object)value);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to set parameter: '" + param + "' to bean '" + def.name + "'.", ex);
            }
        }
    }

    public <T> T getBean(Class<T> type) {
        String name = this.resolveBeanName(type);
        return (T)this.getBean(name);
    }

    public Object getBean(String name) {
        return this.getBean(name, new HashMap<String, Object>());
    }

    protected Object getBean(String[] names, Map<String, Object> acquiredBeans) {
        for (String name : names) {
            Object bean;
            if (name == null || (bean = this.getBean(name, acquiredBeans)) == null) continue;
            return bean;
        }
        return null;
    }

    protected Object getBean(String name, Map<String, Object> acquiredBeans) {
        Object bean = acquiredBeans.get(name);
        if (bean != null) {
            if (bean == Void.TYPE) {
                throw new PetiteException("Cycle dependencies on constructor injection detected!");
            }
            return bean;
        }
        BeanDefinition def = this.lookupBeanDefinition(name);
        if (def == null) {
            return null;
        }
        bean = def.scopeLookup();
        if (bean == null) {
            bean = this.newBeanInstance(def, acquiredBeans);
            this.wireBean(bean, def, acquiredBeans);
            this.invokeInitMethods(bean, def, Boolean.TRUE);
            this.injectParams(bean, def);
            this.invokeInitMethods(bean, def, Boolean.FALSE);
            def.scopeRegister(bean);
        }
        return bean;
    }

    public void wire(Object bean) {
        this.wire(bean, null, this.petiteConfig.getDefaultRunInitMethods());
    }

    public void wire(Object bean, WiringMode wiringMode, boolean init) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = new BeanDefinition(null, bean.getClass(), null, wiringMode);
        this.wireBean(bean, def, new HashMap<String, Object>());
        if (init) {
            this.invokeInitMethods(bean, def, null);
        }
    }

    public <E> E createBean(Class<E> type) {
        return this.createBean(type, null, this.petiteConfig.getDefaultRunInitMethods());
    }

    public <E> E createBean(Class<E> type, WiringMode wiringMode, boolean init) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = new BeanDefinition(null, type, null, wiringMode);
        HashMap<String, Object> acquiredBeans = new HashMap<String, Object>();
        Object bean = this.newBeanInstance(def, acquiredBeans);
        this.wireBean(bean, def, acquiredBeans);
        if (init) {
            this.invokeInitMethods(bean, def, null);
        }
        return (E)bean;
    }

    public void addBean(String name, Object bean) {
        this.addBean(name, bean, null);
    }

    public void addBean(String name, Object bean, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        this.registerBean(name, bean.getClass(), SingletonScope.class, wiringMode);
        BeanDefinition def = this.lookupExistingBeanDefinition(name);
        HashMap<String, Object> acquiredBeans = new HashMap<String, Object>();
        acquiredBeans.put(name, bean);
        this.wireBean(bean, def, acquiredBeans);
        this.invokeInitMethods(bean, def, Boolean.TRUE);
        this.injectParams(bean, def);
        this.invokeInitMethods(bean, def, Boolean.FALSE);
        def.scopeRegister(bean);
    }

    public void addSelf(String name) {
        this.addBean(name, this, WiringMode.NONE);
    }

    public void addSelf() {
        this.addBean(PETITE_CONTAINER_REF_NAME, this, WiringMode.NONE);
    }

    public void setBeanProperty(String name, Object value) {
        String beanName;
        Object bean = null;
        int ndx = name.length();
        while ((ndx = name.lastIndexOf(46, ndx)) != -1 && (bean = this.getBean(beanName = name.substring(0, ndx))) == null) {
            --ndx;
        }
        if (bean == null) {
            throw new PetiteException("Invalid bean property: " + name);
        }
        try {
            BeanUtil.setDeclaredProperty((Object)bean, (String)name.substring(ndx + 1), (Object)value);
        }
        catch (Exception ex) {
            throw new PetiteException("Unable to set bean property: " + name, ex);
        }
    }

    public Object getBeanProperty(String name) {
        int ndx = name.indexOf(46);
        if (ndx == -1) {
            throw new PetiteException("Only bean name is specified, missing property name: " + name);
        }
        String beanName = name.substring(0, ndx);
        Object bean = this.getBean(beanName);
        if (bean == null) {
            throw new PetiteException("Bean doesn't exist: " + name);
        }
        try {
            return BeanUtil.getDeclaredProperty((Object)bean, (String)name.substring(ndx + 1));
        }
        catch (Exception ex) {
            throw new PetiteException("Unable to set bean property: " + name, ex);
        }
    }
}

