/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.db;

import jodd.db.DbSession;
import jodd.db.connection.ConnectionProvider;
import jodd.jtx.JtxException;
import jodd.jtx.JtxResourceManager;
import jodd.jtx.JtxTransactionMode;
import jodd.jtx.db.JtxDbUtil;
import jodd.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbJtxResourceManager
implements JtxResourceManager<DbSession> {
    private static final Log log = Log.getLogger(DbJtxResourceManager.class);
    protected final ConnectionProvider connectionProvider;

    public DbJtxResourceManager(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public Class<DbSession> getResourceType() {
        return DbSession.class;
    }

    @Override
    public DbSession beginTransaction(JtxTransactionMode jtxMode, boolean active) {
        DbSession session = new DbSession(this.connectionProvider);
        if (active) {
            if (log.isDebugEnabled()) {
                log.debug("begin jtx");
            }
            session.beginTransaction(JtxDbUtil.convertToDbMode(jtxMode));
        }
        return session;
    }

    @Override
    public void commitTransaction(DbSession resource) {
        if (resource.isTransactionActive()) {
            if (log.isDebugEnabled()) {
                log.debug("commit jtx");
            }
            resource.commitTransaction();
        }
        resource.closeSession();
    }

    @Override
    public void rollbackTransaction(DbSession resource) {
        try {
            if (resource.isTransactionActive()) {
                if (log.isDebugEnabled()) {
                    log.debug("rollback tx");
                }
                resource.rollbackTransaction();
            }
        }
        catch (Exception ex) {
            throw new JtxException(ex);
        }
        finally {
            resource.closeSession();
        }
    }

    @Override
    public void close() {
        this.connectionProvider.close();
    }
}

