/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.TemplateData;
import jodd.util.CharUtil;

public abstract class SqlChunk
implements Cloneable {
    public static final int COLS_NA = 0;
    public static final int COLS_ONLY_EXISTING = 1;
    public static final int COLS_ONLY_IDS = 2;
    public static final int COLS_ALL = 3;
    protected final int chunkType;
    public static final int CHUNK_RAW = -1;
    public static final int CHUNK_SELECT_COLUMNS = 1;
    public static final int CHUNK_TABLE = 2;
    public static final int CHUNK_REFERENCE = 3;
    public static final int CHUNK_MATCH = 4;
    public static final int CHUNK_VALUE = 5;
    public static final int CHUNK_INSERT = 5;
    public static final int CHUNK_UPDATE = 6;
    protected SqlChunk previousChunk;
    protected SqlChunk nextChunk;
    protected TemplateData templateData;

    protected SqlChunk(int chunkType) {
        this.chunkType = chunkType;
    }

    public SqlChunk getPreviousChunk() {
        return this.previousChunk;
    }

    public SqlChunk getNextChunk() {
        return this.nextChunk;
    }

    public void insertChunkAfter(SqlChunk previous) {
        SqlChunk next = previous.nextChunk;
        previous.nextChunk = this;
        this.previousChunk = previous;
        if (next != null) {
            next.previousChunk = this;
            this.nextChunk = next;
        }
    }

    public boolean isPreviousChunkOfType(int type) {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType == type;
    }

    public boolean isPreviousChunkOfSameType() {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType == this.chunkType;
    }

    public boolean isPreviousMacroChunk() {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType != -1;
    }

    public boolean isPreviousRawChunk() {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType == -1;
    }

    public void init(TemplateData templateData) {
        this.templateData = templateData;
    }

    public abstract void process(StringBuilder var1);

    protected DbEntityDescriptor lookupName(String entityName) {
        DbEntityDescriptor ded = this.templateData.getDbOomManager().lookupName(entityName);
        if (ded == null) {
            throw new DbSqlBuilderException("Entity name '" + entityName + "' is not registered with DbOomManager.");
        }
        return ded;
    }

    protected DbEntityDescriptor lookupType(Class entity) {
        DbEntityDescriptor ded = this.templateData.getDbOomManager().lookupType(entity);
        if (ded == null) {
            throw new DbSqlBuilderException("Invalid or not-persistent entity type: " + entity.getName());
        }
        return ded;
    }

    protected DbEntityDescriptor lookupTableRef(String tableRef) {
        return this.lookupTableRef(tableRef, true);
    }

    protected DbEntityDescriptor lookupTableRef(String tableRef, boolean throwExceptionIfNotFound) {
        DbEntityDescriptor ded = this.templateData.getTableDescriptor(tableRef);
        if (ded == null && throwExceptionIfNotFound) {
            throw new DbSqlBuilderException("Invalid table reference: " + tableRef);
        }
        return ded;
    }

    protected DbEntityDescriptor findColumnRef(String columnRef) {
        DbEntityDescriptor ded = this.templateData.findTableDescriptorByColumnRef(columnRef);
        if (ded == null) {
            throw new DbSqlBuilderException("Invalid column reference: " + columnRef);
        }
        return ded;
    }

    protected String resolveTable(String tableRef, DbEntityDescriptor ded) {
        String tableAlias = this.templateData.getTableAlias(tableRef);
        if (tableAlias != null) {
            return tableAlias;
        }
        return ded.getTableName();
    }

    protected void defineParameter(StringBuilder query, String name, Object value, DbEntityColumnDescriptor dec) {
        if (name == null) {
            name = this.templateData.getNextParameterName();
        }
        query.append(':').append(name);
        this.templateData.addParameter(name, value, dec);
    }

    protected static Class resolveClass(Object object) {
        Class type = object.getClass();
        return type == Class.class ? (Class)object : type;
    }

    protected void appendMissingSpace(StringBuilder out) {
        int len = out.length();
        if (len == 0) {
            return;
        }
        if (!CharUtil.isWhitespace((char)out.charAt(--len))) {
            out.append(' ');
        }
    }

    protected void separateByCommaOrSpace(StringBuilder out) {
        if (this.isPreviousChunkOfSameType()) {
            out.append(',').append(' ');
        } else {
            this.appendMissingSpace(out);
        }
    }

    public abstract SqlChunk clone();
}

