/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen;

import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

class TemplateParser {
    protected static final char ESCAPE_CHARACTER = '\\';
    protected static final String MACRO_TABLE = "$T{";
    protected static final String MACRO_COLUMN = "$C{";
    protected static final String MACRO_MATCH = "$M{";
    protected static final String MACRO_VALUE = "$V{";

    TemplateParser() {
    }

    public void parse(DbSqlBuilder sqlBuilder, String template) {
        int length = template.length();
        int last = 0;
        while (true) {
            int end;
            int mark;
            if ((mark = template.indexOf(36, last)) == -1) {
                if (last >= length) break;
                sqlBuilder.appendRaw(template.substring(last));
                break;
            }
            int escapesCount = this.countEscapes(template, mark);
            if (escapesCount > 0) {
                boolean isEscaped = escapesCount % 2 != 0;
                int escapesToAdd = escapesCount >> 1;
                sqlBuilder.appendRaw(template.substring(last, mark - escapesCount + escapesToAdd) + '$');
                if (isEscaped) {
                    last = mark + 1;
                    continue;
                }
            } else {
                sqlBuilder.appendRaw(template.substring(last, mark));
            }
            if (template.startsWith(MACRO_TABLE, mark)) {
                end = this.findMacroEnd(template, mark += MACRO_TABLE.length());
                this.onTable(sqlBuilder, template.substring(mark, end));
            } else if (template.startsWith(MACRO_COLUMN, mark)) {
                end = this.findMacroEnd(template, mark += MACRO_COLUMN.length());
                this.onColumn(sqlBuilder, template.substring(mark, end));
            } else if (template.startsWith(MACRO_MATCH, mark)) {
                end = this.findMacroEnd(template, mark += MACRO_MATCH.length());
                this.onMatch(sqlBuilder, template.substring(mark, end));
            } else if (template.startsWith(MACRO_VALUE, mark)) {
                end = this.findMacroEnd(template, mark += MACRO_VALUE.length());
                this.onValue(sqlBuilder, template.substring(mark, end));
            } else {
                for (end = ++mark; end < length && TemplateParser.isReferenceChar(template, end); ++end) {
                }
                this.onReference(sqlBuilder, template.substring(mark, end));
                --end;
            }
            last = ++end;
        }
    }

    protected static boolean isReferenceChar(String template, int index) {
        char c = template.charAt(index);
        if (c == '+' && template.charAt(index - 1) == '.') {
            return true;
        }
        return CharUtil.isDigit((char)c) || CharUtil.isLetter((char)c) || c == '_' || c == '.';
    }

    protected int findMacroEnd(String template, int fromIndex) {
        int endIndex = template.indexOf(125, fromIndex);
        if (endIndex == -1) {
            throw new DbSqlBuilderException("Template not formed properly, some macros are not closed. Error at: '..." + template.substring(fromIndex));
        }
        return endIndex;
    }

    protected int countEscapes(String template, int macroIndex) {
        --macroIndex;
        int escapeCount = 0;
        while (macroIndex >= 0 && template.charAt(macroIndex) == '\\') {
            ++escapeCount;
            --macroIndex;
        }
        return escapeCount;
    }

    protected void onTable(DbSqlBuilder sqlBuilder, String allTables) {
        String[] tables;
        for (String table : tables = StringUtil.split((String)allTables, (String)",")) {
            sqlBuilder.table(table);
        }
    }

    protected void onColumn(DbSqlBuilder sqlBuilder, String allColumns) {
        String[] columns;
        for (String column : columns = StringUtil.split((String)allColumns, (String)",")) {
            sqlBuilder.column(column);
        }
    }

    protected void onReference(DbSqlBuilder sqlBuilder, String reference) {
        sqlBuilder.ref(reference);
    }

    protected void onMatch(DbSqlBuilder sqlBuilder, String expression) {
        sqlBuilder.match(expression);
    }

    protected void onValue(DbSqlBuilder sqlBuilder, String expression) {
        sqlBuilder.columnValue(expression);
    }
}

