/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.naming;

import jodd.db.oom.naming.BaseNamingStrategy;
import jodd.util.StringUtil;

public class ColumnNamingStrategy
extends BaseNamingStrategy {
    public String convertPropertyNameToColumnName(String propertyName) {
        StringBuilder tableName = new StringBuilder(propertyName.length() * 2);
        if (this.splitCamelCase) {
            String convertedTableName = StringUtil.fromCamelCase((String)propertyName, (char)this.separatorChar);
            tableName.append(convertedTableName);
        } else {
            tableName.append(propertyName);
        }
        if (!this.changeCase) {
            return tableName.toString();
        }
        return this.uppercase ? ColumnNamingStrategy.toUppercase(tableName).toString() : ColumnNamingStrategy.toLowercase(tableName).toString();
    }

    public String convertColumnNameToPropertyName(String columnName) {
        StringBuilder propertyName = new StringBuilder(columnName.length());
        int len = columnName.length();
        if (this.splitCamelCase) {
            boolean toUpper = false;
            for (int i = 0; i < len; ++i) {
                char c = columnName.charAt(i);
                if (c == this.separatorChar) {
                    toUpper = true;
                    continue;
                }
                if (toUpper) {
                    propertyName.append(Character.toUpperCase(c));
                    toUpper = false;
                    continue;
                }
                propertyName.append(Character.toLowerCase(c));
            }
            return propertyName.toString();
        }
        return columnName;
    }
}

