/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.Iterator;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.mapper.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbListOneIterator<T>
implements Iterator<T> {
    protected DbOomQuery query;
    protected ResultSetMapper resultSetMapper;
    protected boolean closeOnEnd;
    protected Class type;
    protected boolean one;

    DbListOneIterator(DbOomQuery query, Class<T> type) {
        this(query, type, true);
    }

    DbListOneIterator(DbOomQuery query, Class<T> type, boolean closeOnEnd) {
        this.query = query;
        this.resultSetMapper = query.executeAndBuildResultSetMapper();
        this.type = type == null ? this.resultSetMapper.resolveTables()[0] : type;
        this.closeOnEnd = closeOnEnd;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing is not supported.");
    }

    @Override
    public boolean hasNext() {
        if (this.resultSetMapper.next()) {
            return true;
        }
        if (this.closeOnEnd) {
            this.query.close();
        } else {
            this.query.closeResultSet(this.resultSetMapper.getResultSet());
        }
        return false;
    }

    @Override
    public T next() {
        return (T)this.resultSetMapper.parseOneObject(this.type);
    }
}

