/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import jodd.db.DbSession;
import jodd.db.ThreadDbSessionHolder;
import jodd.db.connection.ConnectionProvider;

public class DbThreadSession
extends DbSession {
    public DbThreadSession(ConnectionProvider connectionProvider) {
        super(connectionProvider);
        DbSession session = ThreadDbSessionHolder.get();
        if (session != null) {
            session.closeSession();
        }
        ThreadDbSessionHolder.set(this);
    }

    public DbThreadSession() {
        this(null);
    }

    public void closeSession() {
        ThreadDbSessionHolder.remove();
        super.closeSession();
    }

    public static DbSession getCurrentSession() {
        return ThreadDbSessionHolder.get();
    }

    public static DbThreadSession getThreadSession() {
        DbThreadSession session = (DbThreadSession)ThreadDbSessionHolder.get();
        if (session == null) {
            session = new DbThreadSession();
        }
        return session;
    }

    public static void closeThreadSession() {
        DbThreadSession session = (DbThreadSession)ThreadDbSessionHolder.get();
        if (session != null) {
            session.closeSession();
        }
    }
}

