/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.ActionAnnotationData;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.petite.meta.PetiteInject;
import jodd.util.AnnotationDataReader;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodParser {
    protected static final String REPL_PACKAGE = "[package]";
    protected static final String REPL_CLASS = "[class]";
    protected static final String REPL_METHOD = "[method]";
    protected static final String REPL_EXTENSION = "[ext]";
    @PetiteInject
    protected MadvocConfig madvocConfig;

    public ActionConfig parse(Class<?> actionClass, Method actionMethod) {
        return this.parse(actionClass, actionMethod, null);
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod, String actionPath) {
        ActionAnnotation<?> actionAnnotation;
        Class<? extends ActionInterceptor>[] interceptorClasses;
        Class<?> superClass = null;
        if (actionClass.getAnnotation(MadvocAction.class) == null && ((superClass = actionClass.getSuperclass()) == Object.class || superClass.getAnnotation(MadvocAction.class) == null)) {
            superClass = null;
        }
        if ((interceptorClasses = this.readMethodInterceptors(actionMethod)) == null) {
            interceptorClasses = this.readClassInterceptors(superClass != null ? superClass : actionClass);
        }
        String packageActionPath = this.readPackageActionPath(superClass != null ? superClass : actionClass);
        String classActionPath = this.readClassActionPath(superClass != null ? superClass : actionClass);
        if (classActionPath == null) {
            return null;
        }
        AnnotationDataReader.AnnotationData annotationData = null;
        ActionAnnotation<?>[] arr$ = this.madvocConfig.getActionAnnotationInstances();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (annotationData = (actionAnnotation = arr$[i$]).readAnnotationData(actionMethod)) == null; ++i$) {
        }
        String actionMethodName = actionMethod.getName();
        String methodActionPath = this.readMethodActionPath(actionMethodName, (ActionAnnotationData)annotationData);
        String extension = this.readMethodExtension((ActionAnnotationData)annotationData);
        String alias = this.readMethodAlias((ActionAnnotationData)annotationData);
        String httpMethod = this.readMethodHttpMethod((ActionAnnotationData)annotationData);
        if (methodActionPath != null) {
            methodActionPath = StringUtil.replace((String)methodActionPath, (String)REPL_EXTENSION, (String)extension);
            for (String path : this.madvocConfig.getDefaultActionMethodNames()) {
                if (!methodActionPath.equals(path)) continue;
                methodActionPath = null;
                break;
            }
        }
        if (actionPath == null) {
            actionPath = this.buildActionPath(packageActionPath, classActionPath, methodActionPath, extension, httpMethod);
        }
        if (alias != null) {
            String aliasPath = StringUtil.cutToIndexOf((String)actionPath, (String)"#");
            this.madvocConfig.registerPathAlias(alias, aliasPath);
        } else if (this.madvocConfig.isCreateDefaultAliases()) {
            alias = actionClass.getName() + '#' + actionMethod.getName();
            this.madvocConfig.registerPathAlias(alias, actionPath);
        }
        return this.createActionConfig(actionClass, actionMethod, interceptorClasses, actionPath, httpMethod, extension);
    }

    protected String buildActionPath(String packageActionPath, String classActionPath, String methodActionPath, String extension, String httpMethod) {
        String pathSeparator = "/";
        String actionPath = classActionPath;
        if (methodActionPath != null) {
            if (methodActionPath.startsWith(pathSeparator)) {
                return methodActionPath;
            }
            if (extension != null) {
                methodActionPath = methodActionPath + '.' + extension;
            }
            if (!classActionPath.endsWith(pathSeparator)) {
                actionPath = actionPath + ".";
            }
            actionPath = actionPath + methodActionPath;
        } else if (extension != null) {
            actionPath = actionPath + '.' + extension;
        }
        if (actionPath.startsWith(pathSeparator)) {
            return actionPath;
        }
        actionPath = packageActionPath != null ? packageActionPath + actionPath : pathSeparator + actionPath;
        return actionPath;
    }

    protected Class<? extends ActionInterceptor>[] readClassInterceptors(Class actionClass) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClass.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionInterceptor>[] readMethodInterceptors(Method actionMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected String readPackageActionPath(Class actionClass) {
        String packagePath;
        String packageActionPath;
        String packageRoot = this.madvocConfig.getRootPackage();
        if (packageRoot == null) {
            return null;
        }
        MadvocAction madvocActionAnnotation = actionClass.getPackage().getAnnotation(MadvocAction.class);
        String string = packageActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)packageActionPath)) {
            packageActionPath = null;
        }
        packagePath = (packagePath = actionClass.getPackage().getName()).length() > packageRoot.length() ? StringUtil.cutPrefix((String)packagePath, (String)(packageRoot + '.')) : StringUtil.cutPrefix((String)packagePath, (String)packageRoot);
        packagePath = packagePath.replace('.', '/');
        packageActionPath = packageActionPath == null ? packagePath : StringUtil.replace((String)packageActionPath, (String)REPL_PACKAGE, (String)packagePath);
        return StringUtil.surround((String)packageActionPath, (String)"/");
    }

    protected String readClassActionPath(Class actionClass) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)classActionPath)) {
            classActionPath = null;
        }
        String name = actionClass.getSimpleName();
        name = StringUtil.uncapitalize((String)name);
        name = MadvocUtil.stripLastCamelWord(name);
        classActionPath = classActionPath == null ? name : StringUtil.replace((String)classActionPath, (String)REPL_CLASS, (String)name);
        return classActionPath;
    }

    protected String readMethodActionPath(String methodName, ActionAnnotationData annotationData) {
        String methodActionPath;
        String string = methodActionPath = annotationData != null ? annotationData.getValue() : null;
        if (methodActionPath == null) {
            methodActionPath = methodName;
        } else {
            if (methodActionPath.equals("#")) {
                return null;
            }
            methodActionPath = StringUtil.replace((String)methodActionPath, (String)REPL_METHOD, (String)methodName);
        }
        return methodActionPath;
    }

    protected String readMethodExtension(ActionAnnotationData annotationData) {
        String annExtension;
        String extension = this.madvocConfig.getDefaultExtension();
        if (annotationData != null && (annExtension = annotationData.getExtension()) != null) {
            extension = annExtension.equals("#") ? null : StringUtil.replace((String)annExtension, (String)REPL_EXTENSION, (String)extension);
        }
        return extension;
    }

    protected String readMethodAlias(ActionAnnotationData annotationData) {
        String alias = null;
        if (annotationData != null) {
            alias = annotationData.getAlias();
        }
        return alias;
    }

    private String readMethodHttpMethod(ActionAnnotationData annotationData) {
        String method = null;
        if (annotationData != null) {
            method = annotationData.getMethod();
        }
        return method;
    }

    protected ActionConfig createActionConfig(Class actionClass, Method actionClassMethod, Class<? extends ActionInterceptor>[] interceptorClasses, String actionPath, String actionMethod, String actionPathExtension) {
        return new ActionConfig(actionClass, actionClassMethod, interceptorClasses, actionPath, actionMethod, actionPathExtension);
    }
}

