/*
 * Decompiled with CFR 0.152.
 */
package jodd.log;

import jodd.log.Log;
import jodd.log.LogFactory;

public class ConsoleLog
extends Log {
    protected Level logLevel = Level.INFO;

    public static LogFactory getFactory(final Level currentLevel) {
        return new LogFactory(){

            public Log getLogger(String name) {
                return new ConsoleLog(name, currentLevel);
            }
        };
    }

    public ConsoleLog(String name, Level logLevel) {
        super(name);
        this.logLevel = logLevel;
    }

    public boolean isTraceEnabled() {
        return this.logLevel.isEnabled(Level.TRACE);
    }

    public void trace(String message) {
        System.out.println("TRACE [" + this.getName() + "]: " + message);
    }

    public boolean isDebugEnabled() {
        return this.logLevel.isEnabled(Level.DEBUG);
    }

    public void debug(String message) {
        System.out.println("DEBUG [" + this.getName() + "]: " + message);
    }

    public boolean isInfoEnabled() {
        return this.logLevel.isEnabled(Level.INFO);
    }

    public void info(String message) {
        System.out.println("INFO  [" + this.getName() + "]: " + message);
    }

    public boolean isWarnEnabled() {
        return this.logLevel.isEnabled(Level.WARN);
    }

    public void warn(String message) {
        System.out.println("WARN  [" + this.getName() + "]: " + message);
    }

    public void warn(String message, Throwable throwable) {
        System.out.println("WARN  [" + this.getName() + "]: " + message);
        throwable.printStackTrace();
    }

    public boolean isErrorEnabled() {
        return this.logLevel.isEnabled(Level.ERROR);
    }

    public void error(String message) {
        System.out.println("ERROR [" + this.getName() + "]: " + message);
    }

    public void error(String message, Throwable throwable) {
        System.out.println("ERROR [" + this.getName() + "]: " + message);
        throwable.printStackTrace();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE(1),
        DEBUG(2),
        INFO(3),
        WARN(4),
        ERROR(5);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public boolean isEnabled(Level someLevel) {
            return this.level >= someLevel.level;
        }
    }
}

