/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.io.FileNameUtil;
import jodd.log.Log;
import jodd.servlet.DispatcherUtil;
import jodd.servlet.filter.CharArrayResponseWrapper;

public abstract class LagartoServletFilter
implements Filter {
    private static final Log log = Log.getLogger(LagartoServletFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String actionPath = DispatcherUtil.getServletPath((HttpServletRequest)request);
        if (!this.acceptActionPath(request, actionPath)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        CharArrayResponseWrapper wrapper = new CharArrayResponseWrapper(response);
        filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
        char[] content = wrapper.toCharArray();
        if (content != null && content.length != 0) {
            if (log.isDebugEnabled()) {
                log.debug("Lagarto is about to parse: " + actionPath);
            }
            try {
                content = this.parse(content, request);
            }
            catch (Exception ex) {
                log.error("Error parsing", ex);
                throw new ServletException((Throwable)ex);
            }
            PrintWriter out = servletResponse.getWriter();
            ((Writer)out).write(content);
        }
    }

    protected boolean acceptActionPath(HttpServletRequest request, String actionPath) {
        String extension = FileNameUtil.getExtension((String)actionPath);
        if (extension.length() == 0) {
            return true;
        }
        return extension.equals("html") || extension.equals("htm");
    }

    protected abstract char[] parse(char[] var1, HttpServletRequest var2);
}

