/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import jodd.log.Log;
import jodd.util.StringUtil;

public class DOMBuilderTagVisitor
implements TagVisitor {
    private static final Log log = Log.getLogger(DOMBuilderTagVisitor.class);
    private long startTime;
    protected final boolean caseSensitive;
    protected final boolean parsingHtml;
    protected Document rootNode;
    protected Node parentNode;

    public DOMBuilderTagVisitor(LagartoDOMBuilder builder) {
        this.parsingHtml = builder.isParsingHtml();
        this.caseSensitive = !this.parsingHtml;
    }

    public Document getDocument() {
        return this.rootNode;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("DomTree builder started.");
        }
        this.rootNode = new Document();
        this.parentNode = this.rootNode;
    }

    public void end() {
        if (log.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - this.startTime;
            log.debug("DomTree created in " + elapsed + " ms.");
        }
    }

    public void tag(Tag tag) {
        TagType tagType = tag.getType();
        switch (tagType) {
            case OPEN: {
                Element node = new Element(tag, this.caseSensitive);
                node.forceCloseTag = true;
                this.parentNode.appendChild((Node)node);
                this.parentNode = node;
                break;
            }
            case CLOSE: {
                String tagName = tag.getName();
                Node matchingParent = this.findMatchingParentOpenTag(tagName);
                if (matchingParent == this.parentNode) {
                    this.parentNode = this.parentNode.getParentNode();
                    break;
                }
                if (matchingParent == null) {
                    if (!log.isWarnEnabled()) break;
                    log.warn("Orphan closed tag: </" + tagName + "> ignored.");
                    break;
                }
                this.fixUpToMatchingPoint(matchingParent);
                break;
            }
            case EMPTY: {
                Element node = new Element(tag, this.caseSensitive);
                this.parentNode.appendChild((Node)node);
            }
        }
    }

    protected Node findMatchingParentOpenTag(String tagName) {
        for (Node parent = this.parentNode; parent != null; parent = parent.getParentNode()) {
            if (!tagName.equals(parent.getNodeName())) continue;
            return parent;
        }
        return null;
    }

    protected void fixUpToMatchingPoint(Node matchingParent) {
        while (true) {
            String nodeName = this.parentNode.getNodeName();
            if (this.parentNode == matchingParent) break;
            Node[] childNodes = this.parentNode.getChildNodes();
            this.parentNode.removeAllChilds();
            if (this.parentNode.getNodeType() == Node.NodeType.ELEMENT) {
                ((Element)this.parentNode).forceCloseTag = false;
            }
            Node parentParentNode = this.parentNode.getParentNode();
            for (Node childNode : childNodes) {
                parentParentNode.appendChild(childNode);
            }
            if (log.isWarnEnabled()) {
                log.warn("Unclosed tag: <" + nodeName + "> closed.");
            }
            this.parentNode = parentParentNode;
        }
        this.parentNode = this.parentNode.getParentNode();
    }

    public void xmp(Tag tag, CharSequence body) {
        Element node = new Element(tag, this.caseSensitive);
        this.parentNode.appendChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(((Object)body).toString());
            node.appendChild((Node)text);
        }
    }

    public void style(Tag tag, CharSequence body) {
        Element node = new Element(tag, this.caseSensitive);
        node.forceCloseTag = true;
        this.parentNode.appendChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(((Object)body).toString());
            node.appendChild((Node)text);
        }
    }

    public void script(Tag tag, CharSequence body) {
        Element node = new Element(tag, this.caseSensitive);
        node.forceCloseTag = true;
        this.parentNode.appendChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(((Object)body).toString());
            node.appendChild((Node)text);
        }
    }

    public void comment(CharSequence comment) {
        Comment node = new Comment(((Object)comment).toString());
        this.parentNode.appendChild((Node)node);
    }

    public void text(CharSequence text) {
        String textValue = ((Object)text).toString();
        if (!this.parsingHtml && StringUtil.isBlank((String)textValue)) {
            return;
        }
        Text node = new Text(textValue);
        this.parentNode.appendChild((Node)node);
    }

    public void cdata(CharSequence cdata) {
        CData cdataNode = new CData(((Object)cdata).toString());
        this.parentNode.appendChild((Node)cdataNode);
    }

    public void xml(Tag tag) {
        XmlDeclaration xmlDeclaration = new XmlDeclaration(tag, this.caseSensitive);
        this.parentNode.appendChild((Node)xmlDeclaration);
    }

    public void doctype(String name, String publicId, String baseUri) {
        DocumentType documentType = new DocumentType(name, publicId, baseUri);
        this.parentNode.appendChild((Node)documentType);
    }

    public void condComment(CharSequence conditionalComment, boolean isStartingTag, boolean isDownlevelHidden) {
        Comment comment = new Comment(((Object)conditionalComment).toString(), isStartingTag, isDownlevelHidden);
        this.parentNode.appendChild((Node)comment);
    }

    public void error(String message) {
        if (log.isWarnEnabled()) {
            log.warn("DOM tree may be corrupted due to parsing error. " + message);
        }
    }
}

