/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.csselly.selector;

import jodd.lagarto.csselly.CSSellyException;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Match {
    EQUALS("="){

        public boolean compare(String attr, String val) {
            return val.equals(attr);
        }
    }
    ,
    INCLUDES("~="){

        public boolean compare(String attr, String val) {
            String[] attrarr;
            if (val.length() == 0) {
                return false;
            }
            for (String aa : attrarr = StringUtil.splitc((String)attr, (char)' ')) {
                if (!aa.equals(val)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    DASH("|="){

        public boolean compare(String attr, String val) {
            return attr.equals(val) || attr.startsWith(val + '-');
        }
    }
    ,
    PREFIX("^="){

        public boolean compare(String attr, String val) {
            if (val.length() == 0) {
                return false;
            }
            return attr.startsWith(val);
        }
    }
    ,
    SUFFIX("$="){

        public boolean compare(String attr, String val) {
            if (val.length() == 0) {
                return false;
            }
            return attr.endsWith(val);
        }
    }
    ,
    SUBSTRING("*="){

        public boolean compare(String attr, String val) {
            if (val.length() == 0) {
                return false;
            }
            return attr.contains(val);
        }
    };

    private final String sign;

    private Match(String sign) {
        this.sign = sign;
    }

    public String getSign() {
        return this.sign;
    }

    public abstract boolean compare(String var1, String var2);

    public static Match valueOfSign(String sign) {
        Match[] values;
        for (Match match : values = Match.values()) {
            if (!match.getSign().equals(sign)) continue;
            return match;
        }
        throw new CSSellyException("Invalid match sign: " + sign);
    }

    public static Match valueOfFirstChar(char firstChar) {
        Match[] values;
        for (Match match : values = Match.values()) {
            String matchSign = match.getSign();
            if (matchSign.length() <= 1 || firstChar != matchSign.charAt(0)) continue;
            return match;
        }
        return EQUALS;
    }
}

