/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;

public class XADataSourceConnectionProvider
implements ConnectionProvider {
    private XADataSource xaDataSource;
    private String username;
    private String password;

    public XADataSourceConnectionProvider(XADataSource dataSource) {
        this.xaDataSource = dataSource;
        this.password = null;
        this.username = null;
    }

    public XADataSourceConnectionProvider(XADataSource dataSource, String user, String pass) {
        this.xaDataSource = dataSource;
        this.username = user;
        this.password = pass;
    }

    public void init() {
    }

    public Connection getConnection() {
        try {
            XAConnection xaConnection = this.username != null ? this.xaDataSource.getXAConnection(this.username, this.password) : this.xaDataSource.getXAConnection();
            return xaConnection.getConnection();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get connection from XA datasource.", sex);
        }
    }

    public void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() {
    }
}

