/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;
import jodd.util.ContextUtil;

public class DataSourceConnectionProvider
implements ConnectionProvider {
    private final DataSource dataSource;
    private final String username;
    private final String password;

    public DataSourceConnectionProvider(String jndiName) {
        this(jndiName, null, null);
    }

    public DataSourceConnectionProvider(String jndiName, String user, String pass) {
        try {
            this.dataSource = (DataSource)ContextUtil.getInitContext().lookup(jndiName);
        }
        catch (NamingException nex) {
            throw new DbSqlException("Invalid JNDI datasource name: '" + jndiName + "'.", nex);
        }
        this.username = user;
        this.password = pass;
    }

    public DataSourceConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
        this.password = null;
        this.username = null;
    }

    public DataSourceConnectionProvider(DataSource dataSource, String user, String pass) {
        this.dataSource = dataSource;
        this.username = user;
        this.password = pass;
    }

    public void init() {
    }

    public Connection getConnection() {
        try {
            if (this.username != null || this.password != null) {
                return this.dataSource.getConnection(this.username, this.password);
            }
            return this.dataSource.getConnection();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get connection from datasource.", sex);
        }
    }

    public void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() {
    }
}

