/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.ResultSet;
import jodd.db.DbQuery;
import jodd.db.DbSession;

public class DbProfiledQuery
extends DbQuery {
    long start;
    long elapsed = -1L;

    public DbProfiledQuery(Connection conn, String sql) {
        super(conn, sql);
    }

    public DbProfiledQuery(DbSession session, String sqlString) {
        super(session, sqlString);
    }

    public DbProfiledQuery(String sqlString) {
        super(sqlString);
    }

    public int executeUpdate() {
        this.start = System.currentTimeMillis();
        int result = super.executeUpdate();
        this.elapsed = System.currentTimeMillis() - this.start;
        return result;
    }

    public ResultSet execute() {
        this.start = System.currentTimeMillis();
        ResultSet result = super.execute();
        this.elapsed = System.currentTimeMillis() - this.start;
        return result;
    }

    public long executeCount() {
        this.start = System.currentTimeMillis();
        long count = super.executeCount();
        this.elapsed = System.currentTimeMillis() - this.start;
        return count;
    }

    public long getExecutionElapsedTime() {
        return this.elapsed;
    }

    public String getQueryString() {
        StringBuilder result = new StringBuilder(super.getQueryString());
        if (this.elapsed != -1L) {
            result.append("\nExecution time: ").append(this.elapsed).append("ms.");
        }
        return result.toString();
    }
}

