/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jodd.asm.TraceSignatureVisitor;
import jodd.asm7.signature.SignatureReader;

public class GenericsReader {
    final Map<String, String> genericsMap = new LinkedHashMap<String, String>();

    public Map<String, String> parseSignatureForGenerics(String signature, boolean isInterface) {
        if (signature == null) {
            return Collections.emptyMap();
        }
        int indexOfBracket = signature.indexOf("<");
        final String declaringClass = indexOfBracket > 0 ? signature.substring(1, indexOfBracket) + ":" : null;
        SignatureReader sr = new SignatureReader(signature);
        StringBuilder sb = new StringBuilder();
        TraceSignatureVisitor v = new TraceSignatureVisitor(sb, isInterface){
            String genericName;
            int classTypeCounter;
            {
                super(stringBuilder, isInterface);
                this.classTypeCounter = 0;
            }

            @Override
            public void visitFormalTypeParameter(String name) {
                this.genericName = name;
                super.visitFormalTypeParameter(name);
            }

            @Override
            public void visitClassType(String name) {
                ++this.classTypeCounter;
                if (this.genericName != null) {
                    GenericsReader.this.genericsMap.put(this.genericName, 'L' + name + ';');
                    this.genericName = null;
                } else if (declaringClass != null) {
                    GenericsReader.this.genericsMap.put(declaringClass + (this.classTypeCounter - 1), 'L' + name + ';');
                }
                super.visitClassType(name);
            }
        };
        sr.accept(v);
        return this.genericsMap;
    }
}

