/*
 * Decompiled with CFR 0.152.
 */
package jodd.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import jodd.aop.Aspect;
import jodd.util.ClassUtil;

public class AopProxy {
    public static <T> T proxyOf(T target, Class<? extends Aspect> aspectClass) {
        Aspect aspect;
        try {
            aspect = (Aspect)ClassUtil.newInstance(aspectClass, (Object[])new Object[]{target});
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create new instance of aspect class", e);
        }
        return AopProxy.newProxyInstance(target.getClass().getClassLoader(), aspect, target.getClass().getInterfaces());
    }

    public static <T> T proxyOf(Aspect aspect) {
        Object target = aspect.getTarget();
        return AopProxy.newProxyInstance(target.getClass().getClassLoader(), aspect, target.getClass().getInterfaces());
    }

    public static <T> T newProxyInstance(ClassLoader classloader, InvocationHandler invocationHandler, Class<?> ... interfaces) {
        if (interfaces.length == 0) {
            throw new IllegalArgumentException("No interfaces of target class found.");
        }
        return (T)Proxy.newProxyInstance(classloader, interfaces, invocationHandler);
    }
}

