/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.config;

import java.io.File;
import java.io.InputStream;
import jodd.io.findfile.ClassFinder;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.config.PetiteConfigurator;
import jodd.petite.meta.PetiteBean;
import jodd.util.ClassLoaderUtil;

public class AutomagicPetiteConfigurator
extends ClassFinder
implements PetiteConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicPetiteConfigurator.class);
    protected final byte[] petiteBeanAnnotationBytes = this.getTypeSignatureBytes(PetiteBean.class);
    protected PetiteContainer container;
    protected long elapsed;

    public long getElapsed() {
        return this.elapsed;
    }

    public void configure(PetiteContainer petiteContainer, File[] classpath) {
        this.container = petiteContainer;
        this.rulesEntries.smartMode();
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanPaths(classpath);
        }
        catch (Exception ex) {
            throw new PetiteException("Scan classpath error", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("Petite configured in " + this.elapsed + " ms. Total beans: " + petiteContainer.getTotalBeans());
    }

    @Override
    public void configure(PetiteContainer petiteContainer) {
        this.configure(petiteContainer, ClassLoaderUtil.getDefaultClasspath());
    }

    protected void onEntry(ClassFinder.EntryData entryData) {
        Class beanClass;
        String entryName = entryData.getName();
        InputStream inputStream = entryData.openInputStream();
        if (!this.isTypeSignatureInUse(inputStream, this.petiteBeanAnnotationBytes)) {
            return;
        }
        try {
            beanClass = this.loadClass(entryName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new PetiteException("Unable to load class: " + cnfex, cnfex);
        }
        if (beanClass == null) {
            return;
        }
        PetiteBean petiteBean = beanClass.getAnnotation(PetiteBean.class);
        if (petiteBean == null) {
            return;
        }
        this.container.registerPetiteBean(beanClass, null, null, null, false);
    }
}

