/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import java.util.logging.Level;
import jodd.log.Logger;

public class JDKLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public JDKLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    private Level jodd2jdk(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return Level.FINER;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.logger.isLoggable(this.jodd2jdk(level));
    }

    @Override
    public void log(Logger.Level level, String message) {
        this.logger.log(this.jodd2jdk(level), message);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public void trace(String message) {
        this.logger.log(Level.FINER, message);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String message) {
        this.logger.log(Level.FINE, message);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String message) {
        this.logger.log(Level.INFO, message);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String message) {
        this.logger.log(Level.WARNING, message);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.logger.log(Level.WARNING, message, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String message) {
        this.logger.log(Level.SEVERE, message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.logger.log(Level.SEVERE, message, throwable);
    }
}

