/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import jodd.log.Logger;
import org.apache.commons.logging.Log;

public class JCLLogger
implements Logger {
    private final Log logger;

    public JCLLogger(Log log) {
        this.logger = log;
    }

    @Override
    public String getName() {
        return this.logger.toString();
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void log(Logger.Level level, String message) {
        switch (level) {
            case TRACE: {
                this.logger.trace((Object)message);
                break;
            }
            case DEBUG: {
                this.logger.debug((Object)message);
                break;
            }
            case INFO: {
                this.logger.info((Object)message);
                break;
            }
            case WARN: {
                this.logger.warn((Object)message);
                break;
            }
            case ERROR: {
                this.logger.error((Object)message);
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String message) {
        this.logger.trace((Object)message);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        this.logger.debug((Object)message);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String message) {
        this.logger.info((Object)message);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String message) {
        this.logger.warn((Object)message);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.logger.warn((Object)message, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String message) {
        this.logger.error((Object)message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.logger.error((Object)message, throwable);
    }
}

