/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import jodd.json.JsonContext;
import jodd.json.JsonSerializer;

public class PrettyJsonSerializer
extends JsonSerializer {
    private int deep = 0;
    private boolean breakOnNewObject = true;
    private int identSize = 2;
    private char identChar = (char)32;
    private boolean prefixSeparatorBySpace = true;
    private boolean suffixSeparatorBySpace = true;

    public void identSize(int ident) {
        this.identSize = ident;
    }

    public void identChar(char identChar) {
        this.identChar = identChar;
    }

    private void breakLine(JsonContext jsonContext) {
        jsonContext.write('\n');
        this.ident(jsonContext);
    }

    private void ident(JsonContext jsonContext) {
        for (int i = 0; i < this.deep; ++i) {
            for (int j = 0; j < this.identSize; ++j) {
                jsonContext.write(this.identChar);
            }
        }
    }

    @Override
    public JsonContext createJsonContext(Appendable appendable) {
        return new JsonContext(this, appendable){

            @Override
            public void writeOpenArray() {
                PrettyJsonSerializer.this.deep++;
                super.writeOpenArray();
                if (PrettyJsonSerializer.this.breakOnNewObject) {
                    PrettyJsonSerializer.this.breakLine(this);
                }
            }

            @Override
            public void writeCloseArray() {
                PrettyJsonSerializer.this.deep--;
                PrettyJsonSerializer.this.breakLine(this);
                super.writeCloseArray();
            }

            @Override
            public void writeOpenObject() {
                this.popName();
                PrettyJsonSerializer.this.deep++;
                this.write('{');
                if (PrettyJsonSerializer.this.breakOnNewObject) {
                    PrettyJsonSerializer.this.breakLine(this);
                }
            }

            @Override
            public void writeCloseObject() {
                PrettyJsonSerializer.this.deep--;
                if (PrettyJsonSerializer.this.breakOnNewObject) {
                    PrettyJsonSerializer.this.breakLine(this);
                }
                super.writeCloseObject();
            }

            @Override
            public void writeComma() {
                super.writeComma();
                PrettyJsonSerializer.this.breakLine(this);
            }

            @Override
            public void writeName(String name) {
                if (name != null) {
                    this.writeString(name);
                } else {
                    this.write("null");
                }
                if (PrettyJsonSerializer.this.prefixSeparatorBySpace) {
                    this.write(' ');
                }
                this.write(':');
                if (PrettyJsonSerializer.this.suffixSeparatorBySpace) {
                    this.write(' ');
                }
            }
        };
    }
}

