/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.io.IOException;
import jodd.json.JsonException;
import jodd.util.CharUtil;

public class JsonWriter {
    protected final Appendable out;
    protected String pushedName;
    protected boolean pushedComma;
    protected boolean isPushed;

    public JsonWriter(Appendable out) {
        this.out = out;
    }

    public void pushName(String name, boolean withComma) {
        this.pushedName = name;
        this.pushedComma = withComma;
        this.isPushed = true;
    }

    protected void popName() {
        if (this.isPushed) {
            if (this.pushedComma) {
                this.writeComma();
            }
            String name = this.pushedName;
            this.pushedName = null;
            this.isPushed = false;
            this.writeName(name);
        }
    }

    public boolean isNamePopped() {
        boolean b = !this.isPushed;
        this.isPushed = false;
        return b;
    }

    public void writeOpenObject() {
        this.popName();
        this.write('{');
    }

    public void writeCloseObject() {
        this.write('}');
    }

    public void writeName(String name) {
        if (name != null) {
            this.writeString(name);
        } else {
            this.write("null");
        }
        this.write(':');
    }

    public void writeOpenArray() {
        this.popName();
        this.write('[');
    }

    public void writeCloseArray() {
        this.write(']');
    }

    public void writeString(String value) {
        this.popName();
        this.write("\"");
        int len = value.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    this.write("\\\"");
                    continue block10;
                }
                case '\\': {
                    this.write("\\\\");
                    continue block10;
                }
                case '/': {
                    this.write("\\/");
                    continue block10;
                }
                case '\b': {
                    this.write("\\b");
                    continue block10;
                }
                case '\f': {
                    this.write("\\f");
                    continue block10;
                }
                case '\n': {
                    this.write("\\n");
                    continue block10;
                }
                case '\r': {
                    this.write("\\r");
                    continue block10;
                }
                case '\t': {
                    this.write("\\t");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        this.unicode(c);
                        continue block10;
                    }
                    this.write(c);
                }
            }
        }
        this.write("\"");
    }

    protected void unicode(char c) {
        this.write("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            char hex = CharUtil.int2hex((int)digit);
            this.write(hex);
            n <<= 4;
        }
    }

    public void writeComma() {
        this.write(',');
    }

    public void write(CharSequence charSequence) {
        this.popName();
        try {
            this.out.append(charSequence);
        }
        catch (IOException ioex) {
            throw new JsonException(ioex);
        }
    }

    public void writeNumber(Number number) {
        if (number == null) {
            this.write("null");
            return;
        }
        this.write(number.toString());
    }

    protected void write(char c) {
        try {
            this.out.append(c);
        }
        catch (IOException ioex) {
            throw new JsonException(ioex);
        }
    }
}

