/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import jodd.util.StringUtil;

public class Cookie {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private Integer maxAge;
    private String expires;
    private String path;
    private boolean secure;
    private Integer version;
    private boolean httpOnly;

    public Cookie(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public Cookie(String cookie) {
        int from = 0;
        int ndx = 0;
        cookie = cookie.trim();
        while (ndx < cookie.length()) {
            String value;
            String name;
            int ndx2;
            ndx = cookie.indexOf(59, from);
            if (ndx == -1) {
                ndx = cookie.length();
            }
            if ((ndx2 = cookie.indexOf(61, from)) != -1 && ndx2 < ndx) {
                name = cookie.substring(from, ndx2).trim();
                value = cookie.substring(ndx2 + 1, ndx).trim();
            } else {
                if (from == ndx) {
                    ++ndx;
                    continue;
                }
                name = cookie.substring(from, ndx).trim();
                value = null;
            }
            if (value != null && name.equalsIgnoreCase("Max-Age")) {
                this.setMaxAge(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("Comment")) {
                this.setComment(value);
            } else if (name.equalsIgnoreCase("Domain")) {
                this.setDomain(value);
            } else if (name.equalsIgnoreCase("Path")) {
                this.setPath(value);
            } else if (name.equalsIgnoreCase("Secure")) {
                this.setSecure(true);
            } else if (value != null && name.equalsIgnoreCase("Version")) {
                this.setVersion(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("HttpOnly")) {
                this.setHttpOnly(true);
            } else if (name.equalsIgnoreCase("Expires")) {
                this.setExpires(value);
            } else if (this.name == null && !StringUtil.isBlank((CharSequence)name)) {
                this.setName(name);
                this.setValue(value);
            }
            from = ndx + 1;
        }
    }

    private void setName(String name) {
        if (name.contains(";") || name.contains(",") || name.startsWith("$")) {
            throw new IllegalArgumentException("Invalid cookie name:" + name);
        }
        for (int n = 0; n < name.length(); ++n) {
            char c = name.charAt(n);
            if (c > ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Invalid cookie name:" + name);
        }
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public Cookie setComment(String purpose) {
        this.comment = purpose;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public Cookie setDomain(String pattern) {
        this.domain = pattern.toLowerCase();
        return this;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public Cookie setMaxAge(int expiry) {
        this.maxAge = expiry;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Cookie setPath(String uri) {
        this.path = uri;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie setSecure(boolean flag) {
        this.secure = flag;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Cookie setValue(String newValue) {
        this.value = newValue;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Cookie setVersion(int version) {
        this.version = version;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public String getExpires() {
        return this.expires;
    }

    public Cookie setExpires(String expires) {
        this.expires = expires;
        return this;
    }

    public String toString() {
        StringBuilder cookie = new StringBuilder();
        cookie.append(this.name).append('=').append(this.value);
        if (this.maxAge != null) {
            cookie.append("; Max-Age=").append(this.maxAge);
        }
        if (this.expires != null) {
            cookie.append("; Expires=").append(this.expires);
        }
        if (this.comment != null) {
            cookie.append("; Comment=").append(this.comment);
        }
        if (this.domain != null) {
            cookie.append("; Domain=").append(this.domain);
        }
        if (this.path != null) {
            cookie.append("; Path=").append(this.path);
        }
        if (this.secure) {
            cookie.append("; Secure");
        }
        if (this.version != null) {
            cookie.append("; Version=").append(this.version);
        }
        if (this.httpOnly) {
            cookie.append("; HttpOnly");
        }
        return cookie.toString();
    }
}

