/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import jodd.http.HttpConnection;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpException;
import jodd.http.HttpRequest;
import jodd.http.JoddHttp;
import jodd.http.ProxyInfo;
import jodd.http.net.HTTPProxySocketFactory;
import jodd.http.net.SocketHttpConnection;
import jodd.http.net.SocketHttpSecureConnection;
import jodd.http.net.Socks4ProxySocketFactory;
import jodd.http.net.Socks5ProxySocketFactory;
import jodd.util.StringUtil;

public class SocketHttpConnectionProvider
implements HttpConnectionProvider {
    protected ProxyInfo proxy = ProxyInfo.directProxy();

    @Override
    public void useProxy(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    @Override
    public HttpConnection createHttpConnection(HttpRequest httpRequest) throws IOException {
        SocketHttpConnection httpConnection;
        boolean https = httpRequest.protocol().equalsIgnoreCase("https");
        if (https) {
            SSLSocket sslSocket = this.createSSLSocket(httpRequest.host(), httpRequest.port(), httpRequest.connectionTimeout());
            httpConnection = new SocketHttpSecureConnection(sslSocket);
        } else {
            Socket socket = this.createSocket(httpRequest.host(), httpRequest.port(), httpRequest.connectionTimeout());
            httpConnection = new SocketHttpConnection(socket);
        }
        httpConnection.setTimeout(httpRequest.timeout());
        try {
            httpConnection.init();
        }
        catch (Throwable throwable) {
            httpConnection.close();
            throw new HttpException(throwable);
        }
        return httpConnection;
    }

    protected Socket createSocket(String host, int port, int connectionTimeout) throws IOException {
        SocketFactory socketFactory = this.getSocketFactory(this.proxy);
        if (connectionTimeout < 0) {
            return socketFactory.createSocket(host, port);
        }
        Socket socket = socketFactory.createSocket();
        socket.connect(new InetSocketAddress(host, port), connectionTimeout);
        return socket;
    }

    protected SSLSocket createSSLSocket(String host, int port, int connectionTimeout) throws IOException {
        SSLSocket sslSocket;
        SocketFactory socketFactory;
        try {
            socketFactory = this.getSSLSocketFactory();
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
        if (connectionTimeout < 0) {
            sslSocket = (SSLSocket)socketFactory.createSocket(host, port);
        } else {
            sslSocket = (SSLSocket)socketFactory.createSocket();
            sslSocket.connect(new InetSocketAddress(host, port), connectionTimeout);
        }
        String enabledProtocols = JoddHttp.defaultSecureEnabledProtocols;
        if (enabledProtocols != null) {
            String[] values = StringUtil.splitc((String)enabledProtocols, (char)',');
            StringUtil.trimAll((String[])values);
            sslSocket.setEnabledProtocols(values);
        }
        return sslSocket;
    }

    protected SocketFactory getSSLSocketFactory() throws Exception {
        return SSLSocketFactory.getDefault();
    }

    public SocketFactory getSocketFactory(ProxyInfo proxy) {
        switch (proxy.getProxyType()) {
            case NONE: {
                return SocketFactory.getDefault();
            }
            case HTTP: {
                return new HTTPProxySocketFactory(proxy);
            }
            case SOCKS4: {
                return new Socks4ProxySocketFactory(proxy);
            }
            case SOCKS5: {
                return new Socks5ProxySocketFactory(proxy);
            }
        }
        return null;
    }
}

