/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.meta.DbColumn;
import jodd.db.oom.meta.DbId;
import jodd.db.oom.meta.DbMapTo;
import jodd.db.oom.meta.DbTable;
import jodd.db.oom.naming.ColumnNamingStrategy;
import jodd.db.oom.naming.TableNamingStrategy;
import jodd.db.type.SqlType;
import jodd.introspector.PropertyDescriptor;
import jodd.util.StringUtil;

public class DbMetaUtil {
    public static String resolveTableName(Class<?> type, TableNamingStrategy tableNamingStrategy) {
        String tableName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            tableName = dbTable.value().trim();
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = tableNamingStrategy.convertEntityNameToTableName(type);
        } else if (!tableNamingStrategy.isStrictAnnotationNames()) {
            tableName = tableNamingStrategy.applyToTableName(tableName);
        }
        return DbMetaUtil.quoteIfRequired(tableName, tableNamingStrategy.isAlwaysQuoteNames(), tableNamingStrategy.getQuoteChar());
    }

    public static String resolveSchemaName(Class<?> type, String defaultSchemaName) {
        String schemaName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            schemaName = dbTable.schema().trim();
        }
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = defaultSchemaName;
        }
        return schemaName;
    }

    public static boolean resolveIsAnnotated(Class<?> type) {
        DbTable dbTable = type.getAnnotation(DbTable.class);
        return dbTable != null;
    }

    public static DbEntityColumnDescriptor resolveColumnDescriptors(DbEntityDescriptor dbEntityDescriptor, PropertyDescriptor property, boolean isAnnotated, ColumnNamingStrategy columnNamingStrategy) {
        String columnName = null;
        boolean isId = false;
        Class<SqlType> sqlTypeClass = null;
        DbId dbId = null;
        if (property.getFieldDescriptor() != null) {
            dbId = property.getFieldDescriptor().getField().getAnnotation(DbId.class);
        }
        if (dbId == null && property.getReadMethodDescriptor() != null) {
            dbId = property.getReadMethodDescriptor().getMethod().getAnnotation(DbId.class);
        }
        if (dbId == null && property.getWriteMethodDescriptor() != null) {
            dbId = property.getWriteMethodDescriptor().getMethod().getAnnotation(DbId.class);
        }
        if (dbId != null) {
            columnName = dbId.value().trim();
            sqlTypeClass = dbId.sqlType();
            isId = true;
        } else {
            DbColumn dbColumn = null;
            if (property.getFieldDescriptor() != null) {
                dbColumn = property.getFieldDescriptor().getField().getAnnotation(DbColumn.class);
            }
            if (dbColumn == null && property.getReadMethodDescriptor() != null) {
                dbColumn = property.getReadMethodDescriptor().getMethod().getAnnotation(DbColumn.class);
            }
            if (dbColumn == null && property.getWriteMethodDescriptor() != null) {
                dbColumn = property.getWriteMethodDescriptor().getMethod().getAnnotation(DbColumn.class);
            }
            if (dbColumn != null) {
                columnName = dbColumn.value().trim();
                sqlTypeClass = dbColumn.sqlType();
            } else if (isAnnotated) {
                return null;
            }
        }
        if (StringUtil.isEmpty((CharSequence)columnName)) {
            columnName = columnNamingStrategy.convertPropertyNameToColumnName(property.getName());
        } else if (!columnNamingStrategy.isStrictAnnotationNames()) {
            columnName = columnNamingStrategy.applyToColumnName(columnName);
        }
        if (sqlTypeClass == SqlType.class) {
            sqlTypeClass = null;
        }
        return new DbEntityColumnDescriptor(dbEntityDescriptor, DbMetaUtil.quoteIfRequired(columnName, columnNamingStrategy.isAlwaysQuoteNames(), columnNamingStrategy.getQuoteChar()), property.getName(), property.getType(), isId, sqlTypeClass);
    }

    public static Class[] resolveMappedTypes(Class type) {
        DbMapTo dbMapTo = type.getAnnotation(DbMapTo.class);
        if (dbMapTo == null) {
            return null;
        }
        return dbMapTo.value();
    }

    private static String quoteIfRequired(String name, boolean alwaysQuoteNames, char quoteChar) {
        if (StringUtil.detectQuoteChar((String)name) != '\u0000') {
            return name;
        }
        if (alwaysQuoteNames && quoteChar != '\u0000') {
            return quoteChar + name + quoteChar;
        }
        return name;
    }
}

