/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import jodd.bean.BeanUtil;
import jodd.db.oom.DbOomException;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.util.ArraysUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

public class JoinHintResolver {
    public Object[] join(Object[] data, String hints) {
        if (hints == null) {
            return data;
        }
        return this.join(data, StringUtil.splitc((String)hints, (char)','));
    }

    public Object[] join(Object[] data, String[] hints) {
        if (hints == null) {
            return data;
        }
        HashMap<String, Object> context = new HashMap<String, Object>(hints.length);
        for (int i = 0; i < hints.length; ++i) {
            hints[i] = hints[i].trim();
            String hint = hints[i];
            if (hint.indexOf(46) != -1) continue;
            context.put(hint, data[i]);
        }
        if (context.size() == data.length) {
            return data;
        }
        Object[] result = new Object[context.size()];
        int count = 0;
        for (int i = 0; i < hints.length; ++i) {
            String hint = hints[i];
            int ndx = hint.indexOf(46);
            if (ndx != -1) {
                String hintPropertyName;
                Class hintPropertyType;
                String key = hint.substring(0, ndx);
                Object value = context.get(key);
                if (value == null) {
                    throw new DbOomException("Hint value missing: " + key);
                }
                if (data[i] == null || (hintPropertyType = BeanUtil.getPropertyType(value, (String)(hintPropertyName = hint.substring(ndx + 1)))) == null) continue;
                ClassDescriptor cd = ClassIntrospector.lookup((Class)hintPropertyType);
                if (cd.isCollection()) {
                    try {
                        Collection collection = (Collection)BeanUtil.getDeclaredProperty(value, (String)hintPropertyName);
                        if (collection == null) {
                            collection = (Collection)ReflectUtil.newInstance((Class)hintPropertyType);
                            BeanUtil.setDeclaredPropertySilent(value, (String)hintPropertyName, (Object)collection);
                        }
                        collection.add(data[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new DbOomException(ex);
                    }
                }
                if (cd.isArray()) {
                    try {
                        Object[] array = (Object[])BeanUtil.getDeclaredProperty(value, (String)hintPropertyName);
                        if (array == null) {
                            array = (Object[])Array.newInstance(hintPropertyType.getComponentType(), 1);
                            BeanUtil.setDeclaredPropertySilent(value, (String)hintPropertyName, (Object)array);
                            array[0] = data[i];
                            continue;
                        }
                        Object[] newArray = ArraysUtil.append((Object[])array, (Object)data[i]);
                        if (newArray == array) continue;
                        BeanUtil.setDeclaredPropertySilent(value, (String)hintPropertyName, (Object)newArray);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new DbOomException(ex);
                    }
                }
                BeanUtil.setDeclaredPropertySilent(value, (String)hintPropertyName, (Object)data[i]);
                continue;
            }
            result[count] = data[i];
            ++count;
        }
        return result;
    }
}

