/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.jtx;

import jodd.db.DbTransactionMode;
import jodd.jtx.JtxTransactionMode;

public class JtxDbUtil {
    public static DbTransactionMode convertToDbMode(JtxTransactionMode txMode) {
        int isolation;
        switch (txMode.getIsolationLevel()) {
            case ISOLATION_DEFAULT: {
                isolation = -1;
                break;
            }
            case ISOLATION_NONE: {
                isolation = 0;
                break;
            }
            case ISOLATION_READ_COMMITTED: {
                isolation = 2;
                break;
            }
            case ISOLATION_READ_UNCOMMITTED: {
                isolation = 1;
                break;
            }
            case ISOLATION_REPEATABLE_READ: {
                isolation = 4;
                break;
            }
            case ISOLATION_SERIALIZABLE: {
                isolation = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new DbTransactionMode(isolation, txMode.isReadOnly());
    }
}

