/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.filter;

import com.jme3.terrain.noise.Filter;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilter
implements Filter {
    protected List<Filter> preFilters = new ArrayList<Filter>();
    protected List<Filter> postFilters = new ArrayList<Filter>();
    private boolean enabled = true;

    @Override
    public Filter addPreFilter(Filter filter) {
        this.preFilters.add(filter);
        return this;
    }

    @Override
    public Filter addPostFilter(Filter filter) {
        this.postFilters.add(filter);
        return this;
    }

    @Override
    public FloatBuffer doFilter(float sx, float sy, float base, FloatBuffer data, int size) {
        if (!this.isEnabled()) {
            return data;
        }
        FloatBuffer retval = data;
        for (Filter f : this.preFilters) {
            retval = f.doFilter(sx, sy, base, retval, size);
        }
        retval = this.filter(sx, sy, base, retval, size);
        for (Filter f : this.postFilters) {
            retval = f.doFilter(sx, sy, base, retval, size);
        }
        return retval;
    }

    public abstract FloatBuffer filter(float var1, float var2, float var3, FloatBuffer var4, int var5);

    @Override
    public int getMargin(int size, int margin) {
        if (!this.isEnabled()) {
            return margin;
        }
        for (Filter f : this.preFilters) {
            margin = f.getMargin(size, margin);
        }
        for (Filter f : this.postFilters) {
            margin = f.getMargin(size, margin);
        }
        return margin;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

