/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.util.logging.Logger;

public class CombinerHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(CombinerHeightMap.class.getName());
    public static final int ADDITION = 0;
    public static final int SUBTRACTION = 1;
    private AbstractHeightMap map1;
    private AbstractHeightMap map2;
    private float factor1 = 0.5f;
    private float factor2 = 0.5f;
    private int mode;

    public CombinerHeightMap(AbstractHeightMap map1, AbstractHeightMap map2, int mode) throws Exception {
        if (null == map1 || null == map2) {
            throw new Exception("Height map may not be null");
        }
        if (map1.getSize() != map2.getSize()) {
            throw new Exception("The two maps must be of the same size");
        }
        if (this.factor1 + this.factor2 != 1.0f) {
            throw new Exception("factor1 and factor2 must add to 1.0");
        }
        this.size = map1.getSize();
        this.map1 = map1;
        this.map2 = map2;
        this.setMode(mode);
        this.load();
    }

    public CombinerHeightMap(AbstractHeightMap map1, float factor1, AbstractHeightMap map2, float factor2, int mode) throws Exception {
        if (null == map1 || null == map2) {
            throw new Exception("Height map may not be null");
        }
        if (map1.getSize() != map2.getSize()) {
            throw new Exception("The two maps must be of the same size");
        }
        if (factor1 + factor2 != 1.0f) {
            throw new Exception("factor1 and factor2 must add to 1.0");
        }
        this.setMode(mode);
        this.size = map1.getSize();
        this.map1 = map1;
        this.map2 = map2;
        this.factor1 = factor1;
        this.factor2 = factor2;
        this.mode = mode;
        this.load();
    }

    public void setFactors(float factor1, float factor2) throws Exception {
        if (factor1 + factor2 != 1.0f) {
            throw new Exception("factor1 and factor2 must add to 1.0");
        }
        this.factor1 = factor1;
        this.factor2 = factor2;
    }

    public void setHeightMaps(AbstractHeightMap map1, AbstractHeightMap map2) throws Exception {
        if (null == map1 || null == map2) {
            throw new Exception("Height map may not be null");
        }
        if (map1.getSize() != map2.getSize()) {
            throw new Exception("The two maps must be of the same size");
        }
        this.size = map1.getSize();
        this.map1 = map1;
        this.map2 = map2;
    }

    public void setMode(int mode) throws Exception {
        if (mode != 0 && mode != 1) {
            throw new Exception("Invalid mode");
        }
        this.mode = mode;
    }

    @Override
    public boolean load() {
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        float[] temp1 = this.map1.getHeightMap();
        float[] temp2 = this.map2.getHeightMap();
        if (this.mode == 0) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.heightData[i + j * this.size] = (int)(temp1[i + j * this.size] * this.factor1 + temp2[i + j * this.size] * this.factor2);
                }
            }
        } else if (this.mode == 1) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.heightData[i + j * this.size] = (int)(temp1[i + j * this.size] * this.factor1 - temp2[i + j * this.size] * this.factor2);
                }
            }
        }
        logger.fine("Created heightmap using Combiner");
        return true;
    }
}

