/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.grid;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.TextureKey;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.Vector3f;
import com.jme3.terrain.geomipmap.TerrainGridTileLoader;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.HeightMap;
import com.jme3.terrain.heightmap.ImageBasedHeightMap;
import com.jme3.terrain.heightmap.Namer;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageTileLoader
implements TerrainGridTileLoader {
    private static final Logger logger = Logger.getLogger(ImageTileLoader.class.getName());
    private final AssetManager assetManager;
    private final Namer namer;
    private int patchSize;
    private int quadSize;

    public ImageTileLoader(final String textureBase, final String textureExt, AssetManager assetManager) {
        this(assetManager, new Namer(){

            @Override
            public String getName(int x, int y) {
                return textureBase + "_" + x + "_" + y + "." + textureExt;
            }
        });
    }

    public ImageTileLoader(AssetManager assetManager, Namer namer) {
        this.assetManager = assetManager;
        this.namer = namer;
    }

    public void setHeightScale(float heightScale) {
    }

    private HeightMap getHeightMapAt(Vector3f location) {
        int x = (int)location.x;
        int z = (int)location.z;
        ImageBasedHeightMap heightmap = null;
        String name = null;
        try {
            name = this.namer.getName(x, z);
            logger.log(Level.FINE, "Loading heightmap from file: {0}", name);
            Texture texture = this.assetManager.loadTexture(new TextureKey(name));
            heightmap = new ImageBasedHeightMap(texture.getImage());
            heightmap.setHeightScale(1.0f);
            heightmap.load();
        }
        catch (AssetNotFoundException e) {
            logger.log(Level.WARNING, "Asset {0} not found, loading zero heightmap instead", name);
        }
        return heightmap;
    }

    public void setSize(int size) {
        this.patchSize = size - 1;
    }

    @Override
    public TerrainQuad getTerrainQuadAt(Vector3f location) {
        HeightMap heightMapAt = this.getHeightMapAt(location);
        TerrainQuad q = new TerrainQuad("Quad" + location, this.patchSize, this.quadSize, heightMapAt == null ? null : heightMapAt.getHeightMap());
        return q;
    }

    @Override
    public void setPatchSize(int patchSize) {
        this.patchSize = patchSize;
    }

    @Override
    public void setQuadSize(int quadSize) {
        this.quadSize = quadSize;
    }

    public void write(JmeExporter ex) throws IOException {
    }

    public void read(JmeImporter im) throws IOException {
    }
}

