/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.JmeSystem;
import com.jme3.system.NativeLibraries;
import com.jme3.system.NativeLibrary;
import com.jme3.system.Platform;
import com.jme3.util.res.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeLibraryLoader {
    private static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());
    private static File extractionFolderOverride = null;
    private static File extractionFolder = null;
    private static final HashMap<NativeLibrary.Key, NativeLibrary> nativeLibraryMap = new HashMap();

    public static void registerNativeLibrary(NativeLibrary library) {
        nativeLibraryMap.put(library.getKey(), library);
    }

    public static void registerNativeLibrary(String name, Platform platform, String path, String extractAsName) {
        nativeLibraryMap.put(new NativeLibrary.Key(name, platform), new NativeLibrary(name, platform, path, extractAsName));
    }

    public static void registerNativeLibrary(String name, Platform platform, String path) {
        NativeLibraryLoader.registerNativeLibrary(name, platform, path, null);
    }

    private NativeLibraryLoader() {
    }

    public static boolean isUsingNativeBullet() {
        try {
            Class<?> clazz = Class.forName("com.jme3.bullet.util.NativeMeshUtil");
            return clazz != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void setCustomExtractionFolder(String path) {
        extractionFolderOverride = new File(path).getAbsoluteFile();
    }

    public static File getExtractionFolder() {
        if (extractionFolderOverride != null) {
            return extractionFolderOverride;
        }
        if (extractionFolder == null) {
            File userTempDir = new File(System.getProperty("java.io.tmpdir"));
            if (!userTempDir.canWrite()) {
                NativeLibraryLoader.setExtractionFolderToUserCache();
            } else {
                try {
                    File jmeTempDir = new File(userTempDir, "jme3");
                    if (!jmeTempDir.exists()) {
                        jmeTempDir.mkdir();
                    }
                    if (!(extractionFolder = new File(jmeTempDir, "natives_" + Integer.toHexString(NativeLibraryLoader.computeNativesHash()))).exists()) {
                        extractionFolder.mkdir();
                    }
                }
                catch (Exception e) {
                    NativeLibraryLoader.setExtractionFolderToUserCache();
                }
            }
        }
        return extractionFolder;
    }

    private static File getJmeUserCacheFolder() {
        File userHomeFolder = new File(System.getProperty("user.home"));
        File userCacheFolder = null;
        switch (JmeSystem.getPlatform().getOs()) {
            case Linux: {
                userCacheFolder = new File(userHomeFolder, ".cache");
                break;
            }
            case MacOS: {
                userCacheFolder = new File(new File(userHomeFolder, "Library"), "Caches");
                break;
            }
            case Windows: {
                userCacheFolder = new File(new File(userHomeFolder, "AppData"), "Local");
            }
        }
        if (userCacheFolder == null || !userCacheFolder.exists()) {
            return new File(userHomeFolder, ".jme3");
        }
        return new File(userCacheFolder, "jme3");
    }

    private static void setExtractionFolderToUserCache() {
        File extractFolderInHome = NativeLibraryLoader.getJmeUserCacheFolder();
        if (!extractFolderInHome.exists()) {
            extractFolderInHome.mkdir();
        }
        if (!(extractionFolder = new File(extractFolderInHome, "natives_" + Integer.toHexString(NativeLibraryLoader.computeNativesHash()))).exists()) {
            extractionFolder.mkdir();
        }
        logger.log(Level.WARNING, "Working directory is not writable. Natives will be extracted to:\n{0}", extractionFolder);
    }

    private static int computeNativesHash() {
        URLConnection conn = null;
        String classpath = System.getProperty("java.class.path");
        URL url = Resources.getResource((String)"com/jme3/system/NativeLibraryLoader.class");
        try {
            int hash;
            StringBuilder sb = new StringBuilder(url.toString());
            if (sb.indexOf("jar:") == 0) {
                sb.delete(0, 4);
                sb.delete(sb.indexOf("!"), sb.length());
                sb.delete(sb.lastIndexOf("/") + 1, sb.length());
            }
            try {
                url = new URL(sb.toString());
            }
            catch (MalformedURLException ex) {
                throw new UnsupportedOperationException(ex);
            }
            conn = url.openConnection();
            int n = hash = classpath.hashCode() ^ (int)conn.getLastModified();
            return n;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to open file: '" + url + "'. Error: " + ex, ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.getInputStream().close();
                    conn.getOutputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File[] getJarsWithNatives() {
        HashSet<File> jarFiles = new HashSet<File>();
        for (Map.Entry<NativeLibrary.Key, NativeLibrary> lib : nativeLibraryMap.entrySet()) {
            File jarFile = NativeLibraryLoader.getJarForNativeLibrary(lib.getValue().getPlatform(), lib.getValue().getName());
            if (jarFile == null) continue;
            jarFiles.add(jarFile);
        }
        return jarFiles.toArray(new File[0]);
    }

    public static void extractNativeLibraries(Platform platform, File targetDir) throws IOException {
        for (Map.Entry<NativeLibrary.Key, NativeLibrary> lib : nativeLibraryMap.entrySet()) {
            if (lib.getValue().getPlatform() != platform) continue;
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            NativeLibraryLoader.extractNativeLibrary(platform, lib.getValue().getName(), targetDir);
        }
    }

    private static String unmapLibraryName(String filename) {
        int dot;
        StringBuilder sb = new StringBuilder(filename);
        if (sb.indexOf("lib") == 0 && !filename.toLowerCase().endsWith(".dll")) {
            sb.delete(0, 3);
        }
        if ((dot = sb.lastIndexOf(".")) > 0) {
            sb.delete(dot, sb.length());
        }
        return sb.toString();
    }

    public static File getJarForNativeLibrary(Platform platform, String name) {
        NativeLibrary library = nativeLibraryMap.get(new NativeLibrary.Key(name, platform));
        if (library == null) {
            return null;
        }
        String pathInJar = library.getPathInNativesJar();
        if (pathInJar == null) {
            return null;
        }
        String fileNameInJar = pathInJar.contains("/") ? pathInJar.substring(pathInJar.lastIndexOf("/") + 1) : pathInJar;
        URL url = Resources.getResource((String)pathInJar);
        if (url == null) {
            url = Resources.getResource((String)fileNameInJar);
        }
        if (url == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(url.toString());
        if (sb.indexOf("jar:file:/") == 0) {
            sb.delete(0, 9);
            sb.delete(sb.indexOf("!"), sb.length());
            return new File(sb.toString());
        }
        return null;
    }

    public static void extractNativeLibrary(Platform platform, String name, File targetDir) throws IOException {
        NativeLibrary library = nativeLibraryMap.get(new NativeLibrary.Key(name, platform));
        if (library == null) {
            return;
        }
        String pathInJar = library.getPathInNativesJar();
        if (pathInJar == null) {
            return;
        }
        URL url = Resources.getResource((String)pathInJar);
        if (url == null) {
            return;
        }
        String loadedAsFileName = library.getExtractedAsName() != null ? library.getExtractedAsName() : Paths.get(pathInJar, new String[0]).getFileName().toString();
        URLConnection conn = url.openConnection();
        File targetFile = new File(targetDir, loadedAsFileName);
        try (InputStream in = conn.getInputStream();){
            Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            targetFile.setLastModified(conn.getLastModified());
        }
    }

    public static void loadNativeLibrary(String name, boolean isRequired) {
        URLConnection conn;
        if (JmeSystem.isLowPermissions()) {
            throw new UnsupportedOperationException("JVM is running under reduced permissions. Cannot load native libraries.");
        }
        Platform platform = JmeSystem.getPlatform();
        NativeLibrary library = nativeLibraryMap.get(new NativeLibrary.Key(name, platform));
        if (library == null) {
            if (isRequired) {
                throw new UnsatisfiedLinkError("The required native library '" + name + "' is not available for your OS: " + platform);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The optional native library ''{0}'' is not available for your OS: {1}", new Object[]{name, platform});
            }
            return;
        }
        String pathInJar = library.getPathInNativesJar();
        if (pathInJar == null) {
            return;
        }
        URL url = Resources.getResource((String)pathInJar);
        if (url == null) {
            if (isRequired) {
                throw new UnsatisfiedLinkError("The required native library '" + library.getName() + "' was not found in the classpath via '" + pathInJar);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The optional native library ''{0}'' was not found in the classpath via ''{1}''.", new Object[]{library.getName(), pathInJar});
            }
            return;
        }
        String loadedAsFileName = library.getExtractedAsName() != null ? library.getExtractedAsName() : Paths.get(pathInJar, new String[0]).getFileName().toString();
        File extractionDirectory = NativeLibraryLoader.getExtractionFolder();
        try {
            conn = url.openConnection();
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to open file: '" + url + "'. Error: " + ex, ex);
        }
        File targetFile = new File(extractionDirectory, loadedAsFileName);
        try (InputStream in = conn.getInputStream();){
            if (NativeLibraryLoader.isExtractingRequired(conn, targetFile)) {
                Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                targetFile.setLastModified(conn.getLastModified());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Extracted native library from ''{0}'' into ''{1}''. ", new Object[]{url, targetFile});
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Not copying library {0}. Latest already extracted.", loadedAsFileName);
            }
            library.getLoadFunction().accept(targetFile.getAbsolutePath());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Loaded native library {0}.", library.getName());
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to extract native library to: " + targetFile, ex);
        }
    }

    private static boolean isExtractingRequired(URLConnection conn, File targetFile) {
        if (!targetFile.exists()) {
            return true;
        }
        long targetLastModified = targetFile.lastModified();
        long sourceLastModified = conn.getLastModified();
        return Math.abs(sourceLastModified - targetLastModified) >= 1000L;
    }

    static {
        NativeLibraries.registerDefaultLibraries();
    }
}

