/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Supplier;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.spring.config.JMoleculesConverterConfigUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ObjectMapper.class})
class JMoleculesSpringJacksonAutoConfiguration {
    JMoleculesSpringJacksonAutoConfiguration() {
    }

    @Bean
    AssociationResolvingJacksonModule associationResolvingJacksonModule(BeanFactory beanFactory) {
        Supplier<ConversionService> conversionService = () -> beanFactory.containsBean("mvcConversionService") ? (ConversionService)beanFactory.getBean("mvcConversionService", ConversionService.class) : (ConversionService)beanFactory.getBeanProvider(ConversionService.class).getIfAvailable(() -> JMoleculesConverterConfigUtils.registerConverters(new DefaultFormattingConversionService()));
        return new AssociationResolvingJacksonModule(conversionService);
    }

    static class AssociationResolvingJacksonModule
    extends SimpleModule {
        private static final long serialVersionUID = 919622286584067203L;

        public AssociationResolvingJacksonModule(Supplier<ConversionService> conversionService) {
            super("jmolecules-association-resolving-module");
            this.addDeserializer(Association.class, (JsonDeserializer)new AssociationDeserializer(conversionService));
            this.addSerializer((JsonSerializer)new AssociationSerializer(conversionService));
        }

        private static class AssociationDeserializer
        extends StdDeserializer<Association<?, ?>>
        implements ContextualDeserializer {
            private static final long serialVersionUID = -3979882455489371634L;
            private final Supplier<ConversionService> converter;
            private final BeanProperty property;

            public AssociationDeserializer(Supplier<ConversionService> converter) {
                this(converter, null);
            }

            private AssociationDeserializer(Supplier<ConversionService> converter, BeanProperty property) {
                super(Association.class);
                this.converter = converter;
                this.property = property;
            }

            public Association<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                String source = p.getText();
                if (!StringUtils.hasText((String)source)) {
                    return null;
                }
                List parameters = this.property.getType().getBindings().getTypeParameters();
                ResolvableType associationType = ResolvableType.forClassWithGenerics(Association.class, (Class[])new Class[]{((JavaType)parameters.get(0)).getRawClass(), ((JavaType)parameters.get(1)).getRawClass()});
                return (Association)this.converter.get().convert((Object)p.getText(), TypeDescriptor.valueOf(String.class), new TypeDescriptor(associationType, Association.class, new Annotation[0]));
            }

            public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
                return new AssociationDeserializer(this.converter, property);
            }
        }

        private static class AssociationSerializer
        extends StdSerializer<Association<?, ?>> {
            private static final long serialVersionUID = 610509466313298390L;
            private final Supplier<ConversionService> conversionService;

            AssociationSerializer(Supplier<ConversionService> conversionService) {
                super(Association.class, true);
                this.conversionService = conversionService;
            }

            public void serialize(Association<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                if (value == null) {
                    gen.writeNull();
                    return;
                }
                Object primitive = this.conversionService.get().convert(value, Object.class);
                provider.findValueSerializer(primitive.getClass()).serialize(primitive, gen, provider);
            }
        }
    }
}

