/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring.config;

import java.util.function.Supplier;
import org.jmolecules.spring.AssociationToPrimitivesConverter;
import org.jmolecules.spring.IdentifierToPrimitivesConverter;
import org.jmolecules.spring.PrimitivesToAssociationConverter;
import org.jmolecules.spring.PrimitivesToIdentifierConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.util.Assert;

public class JMoleculesConverterConfigUtils {
    public static <T extends ConfigurableConversionService> T registerConverters(T service) {
        Assert.notNull(service, (String)"ConfigurableConversionService must not be null!");
        Supplier<ConversionService> supplier = () -> service;
        IdentifierToPrimitivesConverter identifierToPrimitives = new IdentifierToPrimitivesConverter(supplier);
        PrimitivesToIdentifierConverter primitivesToIdentifier = new PrimitivesToIdentifierConverter(supplier);
        service.addConverter((GenericConverter)identifierToPrimitives);
        service.addConverter((GenericConverter)primitivesToIdentifier);
        service.addConverter(new PrimitivesToAssociationConverter(primitivesToIdentifier));
        service.addConverter(new AssociationToPrimitivesConverter(identifierToPrimitives));
        return service;
    }
}

