/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.filespecs.entities;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.filespecs.entities.Aql;

public class FilesGroup {
    private Aql aql;
    private String pattern;
    private String target;
    private String props;
    private String targetProps;
    private String recursive;
    private String flat;
    private String regexp;
    private String build;
    private String explode;
    private String[] exclusions;
    private String[] sortBy;
    private String sortOrder;
    private String limit;
    private String offset;
    @Deprecated
    protected String[] excludePatterns;

    public String getAql() {
        if (this.aql != null) {
            return this.aql.getFind();
        }
        return null;
    }

    public FilesGroup setAql(Aql aql) {
        this.aql = aql;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public FilesGroup setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public FilesGroup setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getProps() {
        return this.props;
    }

    public FilesGroup setProps(String props) {
        this.props = props;
        return this;
    }

    public String getTargetProps() {
        return this.targetProps;
    }

    public FilesGroup setTargetProps(String targetProps) {
        this.targetProps = targetProps;
        return this;
    }

    public String getRecursive() {
        return this.recursive;
    }

    public FilesGroup setRecursive(String recursive) {
        this.recursive = recursive;
        return this;
    }

    public String getFlat() {
        return this.flat;
    }

    public FilesGroup setFlat(String flat) {
        this.flat = flat;
        return this;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public FilesGroup setRegexp(String regexp) {
        this.regexp = regexp;
        return this;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public String getExplode() {
        return this.explode;
    }

    public FilesGroup setExplode(String explode) {
        this.explode = explode;
        return this;
    }

    public String[] getExclusions() {
        return this.exclusions;
    }

    public FilesGroup setExclusions(String[] exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public String getExclusion(int index) {
        return this.exclusions[index];
    }

    public String[] getSortBy() {
        if (this.sortBy != null) {
            return this.sortBy;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public FilesGroup setSortBy(String[] sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public FilesGroup setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public String getLimit() {
        return this.limit;
    }

    public FilesGroup setLimit(String resultLimit) {
        this.limit = resultLimit;
        return this;
    }

    public String getOffset() {
        return this.offset;
    }

    public FilesGroup setOffset(String offset) {
        this.offset = offset;
        return this;
    }

    @Deprecated
    public String[] getExcludePatterns() {
        return this.excludePatterns;
    }

    @Deprecated
    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    @Deprecated
    public String getExcludePattern(int index) {
        return this.excludePatterns[index];
    }

    @Deprecated
    public void setExcludePattern(String excludePattern, int index) {
        this.excludePatterns[index] = excludePattern;
    }

    public String toString() {
        return "FilesGroup{aql=" + this.aql + ", pattern='" + this.pattern + '\'' + ", target='" + this.target + '\'' + ", props='" + this.props + '\'' + ", targetProps='" + this.targetProps + '\'' + ", recursive='" + this.recursive + '\'' + ", flat='" + this.flat + '\'' + ", regexp='" + this.regexp + '\'' + ", build='" + this.build + '\'' + ", explode='" + this.explode + '\'' + ", exclusions=" + Arrays.toString(this.exclusions) + ", excludePatterns=" + Arrays.toString(this.excludePatterns) + ", sortBy=" + Arrays.toString(this.sortBy) + ", sortOrder='" + this.sortOrder + '\'' + ", limit='" + this.limit + '\'' + ", offset='" + this.offset + '\'' + '}';
    }

    public SpecType getSpecType() {
        if (StringUtils.isNotEmpty((String)this.build) && StringUtils.isEmpty((String)this.getAql()) && (StringUtils.isEmpty((String)this.pattern) || this.pattern.equals("*"))) {
            return SpecType.BUILD;
        }
        if (StringUtils.isNotEmpty((String)this.pattern)) {
            return SpecType.PATTERN;
        }
        if (StringUtils.isNotEmpty((String)this.getAql())) {
            return SpecType.AQL;
        }
        return null;
    }

    public static enum SpecType {
        BUILD,
        PATTERN,
        AQL;

    }
}

