/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.rest.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.DateUtils;
import org.jfrog.support.rest.model.BundleCreationStatus;
import org.jfrog.support.rest.model.Formats;
import org.jfrog.support.rest.model.SupportBundleParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SupportBundleConfig {
    private String name;
    private String description;
    private String id;
    private Artifactory artifactory;
    private SupportBundleParameters parameters;
    private Integer available;
    @JsonDeserialize(using=DateTimeWithFallbackDeSerializer.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime created;
    private BundleCreationStatus status;

    public static SupportBundleConfigBuilder builder() {
        return new SupportBundleConfigBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public Artifactory getArtifactory() {
        return this.artifactory;
    }

    public SupportBundleParameters getParameters() {
        return this.parameters;
    }

    public Integer getAvailable() {
        return this.available;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public BundleCreationStatus getStatus() {
        return this.status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setArtifactory(Artifactory artifactory) {
        this.artifactory = artifactory;
    }

    public void setParameters(SupportBundleParameters parameters) {
        this.parameters = parameters;
    }

    public void setAvailable(Integer available) {
        this.available = available;
    }

    public void setCreated(ZonedDateTime created) {
        this.created = created;
    }

    public void setStatus(BundleCreationStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupportBundleConfig)) {
            return false;
        }
        SupportBundleConfig other = (SupportBundleConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Artifactory this$artifactory = this.getArtifactory();
        Artifactory other$artifactory = other.getArtifactory();
        if (this$artifactory == null ? other$artifactory != null : !((Object)this$artifactory).equals(other$artifactory)) {
            return false;
        }
        SupportBundleParameters this$parameters = this.getParameters();
        SupportBundleParameters other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Integer this$available = this.getAvailable();
        Integer other$available = other.getAvailable();
        if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
            return false;
        }
        ZonedDateTime this$created = this.getCreated();
        ZonedDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        BundleCreationStatus this$status = this.getStatus();
        BundleCreationStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SupportBundleConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Artifactory $artifactory = this.getArtifactory();
        result = result * 59 + ($artifactory == null ? 43 : ((Object)$artifactory).hashCode());
        SupportBundleParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Integer $available = this.getAvailable();
        result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
        ZonedDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        BundleCreationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "SupportBundleConfig(name=" + this.getName() + ", description=" + this.getDescription() + ", id=" + this.getId() + ", artifactory=" + this.getArtifactory() + ", parameters=" + this.getParameters() + ", available=" + this.getAvailable() + ", created=" + this.getCreated() + ", status=" + this.getStatus() + ")";
    }

    public SupportBundleConfig() {
    }

    public SupportBundleConfig(String name, String description, String id, Artifactory artifactory, SupportBundleParameters parameters, Integer available, ZonedDateTime created, BundleCreationStatus status) {
        this.name = name;
        this.description = description;
        this.id = id;
        this.artifactory = artifactory;
        this.parameters = parameters;
        this.available = available;
        this.created = created;
        this.status = status;
    }

    public static class SupportBundleConfigBuilder {
        private String name;
        private String description;
        private String id;
        private Artifactory artifactory;
        private SupportBundleParameters parameters;
        private Integer available;
        private ZonedDateTime created;
        private BundleCreationStatus status;

        SupportBundleConfigBuilder() {
        }

        public SupportBundleConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SupportBundleConfigBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SupportBundleConfigBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SupportBundleConfigBuilder artifactory(Artifactory artifactory) {
            this.artifactory = artifactory;
            return this;
        }

        public SupportBundleConfigBuilder parameters(SupportBundleParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public SupportBundleConfigBuilder available(Integer available) {
            this.available = available;
            return this;
        }

        public SupportBundleConfigBuilder created(ZonedDateTime created) {
            this.created = created;
            return this;
        }

        public SupportBundleConfigBuilder status(BundleCreationStatus status) {
            this.status = status;
            return this;
        }

        public SupportBundleConfig build() {
            return new SupportBundleConfig(this.name, this.description, this.id, this.artifactory, this.parameters, this.available, this.created, this.status);
        }

        public String toString() {
            return "SupportBundleConfig.SupportBundleConfigBuilder(name=" + this.name + ", description=" + this.description + ", id=" + this.id + ", artifactory=" + this.artifactory + ", parameters=" + this.parameters + ", available=" + this.available + ", created=" + this.created + ", status=" + this.status + ")";
        }
    }

    static class DateTimeWithFallbackDeSerializer
    extends JsonDeserializer<ZonedDateTime> {
        private static final Logger log = LoggerFactory.getLogger(DateTimeWithFallbackDeSerializer.class);

        DateTimeWithFallbackDeSerializer() {
        }

        public ZonedDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                Instant instant = DateUtils.parseDate((String)jsonParser.getText(), (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ssXXX"}).toInstant();
                return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
            }
            catch (ParseException e) {
                log.warn("Error parsing original support bundle creation time: {}. error: {}. will try other parsers", (Object)jsonParser.getText(), (Object)e.getMessage());
                try {
                    Instant instant = DateUtils.parseDate((String)jsonParser.getText(), (String[])Formats.DATE_TIME_OTHER_KNOWN_PATTERNS).toInstant();
                    return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
                }
                catch (ParseException ex) {
                    log.warn("Failed parsing original support bundle creation time: {} with other parsers as well, returning default now()", (Object)jsonParser.getText());
                    return ZonedDateTime.now();
                }
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class Artifactory {
        @NotNull
        private String serviceId;
        @NotNull
        private String bundleUrl;

        public static ArtifactoryBuilder builder() {
            return new ArtifactoryBuilder();
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getBundleUrl() {
            return this.bundleUrl;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public void setBundleUrl(String bundleUrl) {
            this.bundleUrl = bundleUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Artifactory)) {
                return false;
            }
            Artifactory other = (Artifactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$serviceId = this.getServiceId();
            String other$serviceId = other.getServiceId();
            if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
                return false;
            }
            String this$bundleUrl = this.getBundleUrl();
            String other$bundleUrl = other.getBundleUrl();
            return !(this$bundleUrl == null ? other$bundleUrl != null : !this$bundleUrl.equals(other$bundleUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Artifactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceId = this.getServiceId();
            result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
            String $bundleUrl = this.getBundleUrl();
            result = result * 59 + ($bundleUrl == null ? 43 : $bundleUrl.hashCode());
            return result;
        }

        public String toString() {
            return "SupportBundleConfig.Artifactory(serviceId=" + this.getServiceId() + ", bundleUrl=" + this.getBundleUrl() + ")";
        }

        public Artifactory() {
        }

        public Artifactory(String serviceId, String bundleUrl) {
            this.serviceId = serviceId;
            this.bundleUrl = bundleUrl;
        }

        public static class ArtifactoryBuilder {
            private String serviceId;
            private String bundleUrl;

            ArtifactoryBuilder() {
            }

            public ArtifactoryBuilder serviceId(String serviceId) {
                this.serviceId = serviceId;
                return this;
            }

            public ArtifactoryBuilder bundleUrl(String bundleUrl) {
                this.bundleUrl = bundleUrl;
                return this;
            }

            public Artifactory build() {
                return new Artifactory(this.serviceId, this.bundleUrl);
            }

            public String toString() {
                return "SupportBundleConfig.Artifactory.ArtifactoryBuilder(serviceId=" + this.serviceId + ", bundleUrl=" + this.bundleUrl + ")";
            }
        }
    }
}

