/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors.system.info;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.jfrog.support.common.core.collectors.system.info.BasePropInfoGroup;
import org.jfrog.support.common.core.collectors.system.info.InfoObject;
import org.jfrog.support.common.core.collectors.system.info.SystemPropInfoGroup;

public class JavaSysPropInfo
extends BasePropInfoGroup {
    private SystemPropInfoGroup systemPropInfoGroup = new SystemPropInfoGroup("java.class.version", "java.home", "java.io.tmpdir", "java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.url", "java.vendor.url.bug", "java.version", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version", "sun.arch.data.model", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level");
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();

    @Override
    public InfoObject[] getInfo(boolean isSupportBundles) {
        ArrayList infoObjects = Lists.newArrayList((Object[])this.systemPropInfoGroup.getInfo(isSupportBundles));
        List<String> inputArguments = this.runtimeMXBean.getInputArguments();
        boolean addedFirstValue = false;
        String key = "JVM Input arguments";
        for (String inputArgument : inputArguments) {
            infoObjects.add(new InfoObject(key, inputArgument));
            if (addedFirstValue || isSupportBundles) continue;
            addedFirstValue = true;
            key = "";
        }
        return infoObjects.toArray(new InfoObject[infoObjects.size()]);
    }

    @Override
    protected String getGroupName() {
        return "Java System Info";
    }
}

