/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core.collectors;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.jfrog.support.common.ThreadDumper;
import org.jfrog.support.common.config.ThreadDumpConfiguration;
import org.jfrog.support.common.core.AbstractSpecificContentCollector;
import org.jfrog.support.common.core.exceptions.BundleConfigurationException;
import org.jfrog.support.common.utils.StringBuilderWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpCollector
extends AbstractSpecificContentCollector<ThreadDumpConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumpCollector.class);
    private static final String FILE_EXTENSION = ".tdump";
    private final ThreadDumper threadDumper = new ThreadDumper();

    public ThreadDumpCollector() {
        super("thread_dumps");
    }

    @Override
    public Logger getLog() {
        return log;
    }

    @Override
    protected boolean doCollect(ThreadDumpConfiguration configuration, File tmpDir) {
        boolean result = true;
        if (configuration.getCount() > 1) {
            for (short i = 0; i < configuration.getCount(); i = (short)(i + 1)) {
                result &= this.createDump(tmpDir, Optional.of(i));
                if (i == configuration.getCount() - 1) continue;
                result &= this.sleep(configuration.getInterval());
            }
        } else {
            result = this.createDump(tmpDir, Optional.empty());
        }
        if (result) {
            this.getLog().info("Collection of " + this.getContentName() + " was successfully accomplished");
        } else {
            this.getLog().info("Collection of " + this.getContentName() + " has not accomplished successfully");
        }
        return result;
    }

    private boolean sleep(long interval) {
        try {
            this.getLog().debug("Sleeping for {} millis", (Object)interval);
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            this.getLog().error("Error while executing interval on thread dump collection");
            this.getLog().debug("Cause: {}", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean createDump(File tmpDir, Optional<Short> id) {
        try {
            this.getLog().debug("Producing thread dump {}", (Object)(id.isPresent() ? id.get() : (short)1));
            StringBuilderWrapper td = new StringBuilderWrapper(this.threadDumper.dumpThreads());
            Files.write((CharSequence)td, (File)this.getOutputFile(tmpDir, id), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            this.getLog().error("Creating thread dump has failed: " + e.getMessage());
            this.getLog().debug("Cause: {}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected String getFileName() {
        return this.getContentName() + FILE_EXTENSION;
    }

    protected String getFileName(Optional<Short> id) {
        return !id.isPresent() ? this.getFileName() : this.getContextFileName(id);
    }

    protected String getContextFileName(Optional<Short> id) {
        return !id.isPresent() ? this.getFileName() : super.getContentName() + "-" + Integer.toString(id.get() + 1) + FILE_EXTENSION;
    }

    protected File getOutputFile(File tmpDir, Optional<Short> id) {
        return new File(tmpDir.getPath() + File.separator + this.getFileName(id));
    }

    @Override
    protected void doEnsureConfiguration(ThreadDumpConfiguration configuration) throws BundleConfigurationException {
        this.ensureThreadDumpConfig(configuration.getCount(), configuration.getInterval());
    }

    private void ensureThreadDumpConfig(int count, long interval) throws BundleConfigurationException {
        if (count < 0) {
            throw new BundleConfigurationException("ThreadDump configuration is illegal, amount of dumps (count) cannot be negative number");
        }
        if (interval < 0L) {
            throw new BundleConfigurationException("ThreadDump configuration is illegal, dumps interval cannot be negative number");
        }
    }
}

