/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jfrog.support.common.CollectConfiguration;
import org.jfrog.support.common.core.AbstractContentCollector;
import org.jfrog.support.common.core.exceptions.ContentCollectionExceptionException;
import org.jfrog.support.common.utils.StringBuilderWrapper;

public abstract class AbstractGenericContentCollector<T extends CollectConfiguration>
extends AbstractContentCollector<T> {
    protected AbstractGenericContentCollector(String contentName) {
        super(contentName);
    }

    @Override
    protected final boolean doCollect(T configuration, File tmpDir) {
        if (((CollectConfiguration)configuration).isEnabled()) {
            try {
                StringBuilderWrapper content = this.doProduceContent(configuration);
                Files.write((CharSequence)content, (File)this.getOutputFile(tmpDir), (Charset)Charsets.UTF_8);
                this.getLog().info("Collection of " + this.getContentName() + " was successfully accomplished");
                return true;
            }
            catch (IOException | IllegalAccessException | InstantiationException | ContentCollectionExceptionException e) {
                this.getLog().error("Collecting " + this.getContentName() + " has failed, - " + e.getMessage());
                this.getLog().debug("Cause: {}", (Throwable)e);
            }
        } else {
            this.getLog().debug("Content collection of " + this.getContentName() + " is disabled");
        }
        return false;
    }

    protected StringBuilderWrapper failure() {
        throw new ContentCollectionExceptionException("No content was collected for " + this.getContentName());
    }

    protected StringBuilderWrapper failure(Exception e) {
        throw new ContentCollectionExceptionException("No content was collected for " + this.getContentName() + " - " + e.getMessage());
    }

    protected abstract StringBuilderWrapper doProduceContent(T var1) throws IOException, InstantiationException, IllegalAccessException;
}

