/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.support.common.core;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jfrog.support.common.CollectConfiguration;
import org.jfrog.support.common.ContentCollector;
import org.jfrog.support.common.core.exceptions.BundleConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentCollector<T extends CollectConfiguration>
implements ContentCollector<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractContentCollector.class);
    private final String contentName;

    protected AbstractContentCollector(String contentName) {
        this.contentName = contentName;
    }

    @Override
    public final boolean collect(T configuration, File tmpDir) {
        try {
            if (((CollectConfiguration)configuration).isEnabled()) {
                this.getLog().debug("Ensuring configuration is correct for '{}'", (Object)this.getContentName());
                this.doEnsureConfiguration(configuration);
                this.getLog().info("Starting " + this.getContentName() + " collection ...");
                File contentSpecificTmpDir = this.produceTempDirectory(tmpDir);
                this.ensureTempDir(contentSpecificTmpDir);
                return this.doCollect(configuration, contentSpecificTmpDir);
            }
            this.getLog().debug("Configuration {} is disabled", configuration);
        }
        catch (IOException | IllegalStateException e) {
            this.getLog().error("Executing task {} " + this.getContentName() + " has failed (" + e.getMessage() + ")");
            this.getLog().debug("Cause: {}", (Throwable)e);
        }
        return false;
    }

    private File produceTempDirectory(File outputDirectory) {
        return new File(outputDirectory.getAbsolutePath() + File.separator + this.getContentName());
    }

    private void ensureTempDir(File archiveTmpDir) throws IOException {
        FileUtils.forceMkdir((File)archiveTmpDir);
    }

    protected String getContentName() {
        return this.contentName;
    }

    protected File getOutputFile(File tmpDir) {
        return new File(tmpDir.getPath() + File.separator + this.getFileName());
    }

    protected String getFileName() {
        return this.getContentName() + ".artifactory";
    }

    protected Logger getLog() {
        return log;
    }

    protected abstract boolean doCollect(T var1, File var2);

    protected abstract void doEnsureConfiguration(T var1) throws BundleConfigurationException;
}

