/*
 * Copyright (c) 2018. JFrog Ltd. All rights reserved. JFROG PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.jfrog.support.common.core.collectors.system.info;

import java.util.ArrayList;
import java.util.List;

/**
 * A base class for all information groups that use system properties
 *
 * @author Noam Tenne
 */
public class SystemPropInfoGroup extends BasePropInfoGroup {

    /**
     * Property names
     */
    private String[] properties;

    /**
     * Main constructor
     *
     * @param properties A collection of property names
     */
    public SystemPropInfoGroup(String... properties) {
        this.properties = properties;
    }

    public SystemPropInfoGroup() {
    }

    /**
     * Receives property names and sets them in the global variable
     *
     * @param properties
     */
    public void setProperties(String... properties) {
        this.properties = properties;
    }

    /**
     * Returns all the info objects from the current group
     *
     * @return InfoObject[] - Collection of info objects from current group
     */
    @Override
    public InfoObject[] getInfo(boolean isSupportBundles) {
        List<InfoObject> infoList = new ArrayList<>();

        for (String prop : properties) {
            String value = getSystemProperty(prop);
            if (value != null) {
                InfoObject infoObject = new InfoObject(prop, value);
                infoList.add(infoObject);
            }
        }

        return infoList.toArray(new InfoObject[infoList.size()]);
    }

    @Override
    protected String getGroupName() {
        return "System Info";
    }
}