package org.jfrog.common.config.diff;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Mark a bean as diffable, and require the diff engine to create a diff function for it in the generated java
 * {@link DiffFunctions}
 *
 * Read more at:
 * https://docs.google.com/document/d/1b2sjx9lfkNIMvywETeKQbRS7WhI3N1-xddS8IGjgwMs/edit?usp=sharing
 *
 * @author Noam Shemesh
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface GenerateDiffFunction {
    boolean internalDiff() default false;

    boolean withComponentStereotype() default false;

    Class<?> defaultImpl() default Object.class;

    String typeMethod() default "toString";
}
