/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.config.diff;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.common.config.diff.DataDiff;

public abstract class MapToDiffConverter {
    private MapToDiffConverter() {
    }

    public static Set<DataDiff<?>> mapToListOfChanges(Map map) {
        return MapToDiffConverter.internalMapToListOfChanges(map, "");
    }

    private static Set<DataDiff<?>> internalMapToListOfChanges(Map<String, Object> map, String fieldNamePrefix) {
        return map.entrySet().stream().flatMap(entry -> {
            boolean isList = false;
            if (entry.getValue() instanceof Map || (isList = entry.getValue() instanceof List)) {
                Map<String, Object> entryMap;
                if (isList) {
                    List list = (List)entry.getValue();
                    entryMap = IntStream.range(0, list.size()).boxed().collect(Collectors.toMap(i -> String.format("{%d}", i), list::get));
                } else {
                    entryMap = (Map<String, Object>)entry.getValue();
                }
                return MapToDiffConverter.internalMapToListOfChanges(entryMap, MapToDiffConverter.addFieldPrefix(fieldNamePrefix, entry)).stream();
            }
            DataDiff newData = new DataDiff(MapToDiffConverter.addFieldPrefix(fieldNamePrefix, entry), entry.getValue());
            if (entry.getValue() == null || "~".equals(entry.getValue())) {
                return Stream.of(new DataDiff<Object>(MapToDiffConverter.addFieldPrefix(fieldNamePrefix, entry) + "\u00bb$$deleted", null));
            }
            return Stream.of(newData);
        }).collect(Collectors.toSet());
    }

    private static String addFieldPrefix(String fieldNamePrefix, Map.Entry<String, Object> entry) {
        return (String)(StringUtils.isEmpty((CharSequence)fieldNamePrefix) ? "" : fieldNamePrefix + "\u00bb") + entry.getKey();
    }
}

