package org.jfrog.common.config.diff;

import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import static org.jfrog.common.config.diff.DiffMerger.KEY_PLACEHOLDER_FORMAT;

/**
 * A tool to convert a java Map to a list of diffs
 *
 * @author Noam Shemesh
 */
public abstract class MapToDiffConverter {
    private MapToDiffConverter() {}

    public static Set<DataDiff<?>> mapToListOfChanges(Map map) {
        return internalMapToListOfChanges(map, "");
    }

    private static Set<DataDiff<?>> internalMapToListOfChanges(Map<String, Object> map, String fieldNamePrefix) {
        return map.entrySet().stream()
                .flatMap(entry -> {
                    boolean isList = false;
                    if (entry.getValue() instanceof Map || (isList = entry.getValue() instanceof List)) {
                        Map<String, Object> entryMap;
                        if (isList) {
                            List<Object> list = (List<Object>) entry.getValue();
                            entryMap = IntStream.range(0, list.size()).boxed().
                                    collect(Collectors.toMap(i -> String.format(KEY_PLACEHOLDER_FORMAT, i), list::get));
                        } else {
                            entryMap = (Map<String, Object>) entry.getValue();
                        }

                        return internalMapToListOfChanges(entryMap, addFieldPrefix(fieldNamePrefix, entry)).stream();
                    }

                    DataDiff<Object> newData = new DataDiff<>(addFieldPrefix(fieldNamePrefix, entry), entry.getValue());

                    if (entry.getValue() == null || "~".equals(entry.getValue())) {
                        return Stream.of(new DataDiff<>(addFieldPrefix(fieldNamePrefix, entry) + DiffUtils.DELIMITER +
                                DiffUtils.DELETED_MARKER, null));
                    }

                    return Stream.of(newData);
                })
                .collect(Collectors.toSet());
    }

    private static String addFieldPrefix(String fieldNamePrefix, Map.Entry<String, Object> entry) {
        return (StringUtils.isEmpty(fieldNamePrefix) ? "" : fieldNamePrefix + DiffUtils.DELIMITER) + entry.getKey();
    }
}
