/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.common.config.diff;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jfrog.common.ExceptionUtils;
import org.jfrog.common.config.diff.DataDiff;
import org.jfrog.common.config.diff.DiffAtomic;
import org.jfrog.common.config.diff.DiffElement;
import org.jfrog.common.config.diff.DiffKey;
import org.jfrog.common.config.diff.DiffReference;
import org.jfrog.common.config.diff.DiffReferenceable;
import org.jfrog.common.config.diff.DiffUtils;
import org.jfrog.common.config.diff.GenerateDiffFunction;

public abstract class DiffMerger {
    static final String KEY_PLACEHOLDER_FORMAT = "{%d}";
    static final String KEY_PLACEHOLDER_FORMAT_REGEX = "\\{\\d+\\}";
    private static final Pattern KEY_PLACEHOLDER_REGEX = Pattern.compile("^([^\u00bb]*)" + Pattern.quote("\u00bb{") + "(\\d+)" + Pattern.quote("}") + "[" + "\u00bb" + "]?(.*)$");
    private static final int BEFORE_KEY_PLACEHOLDER_GROUP = 1;
    private static final int KEY_PLACEHOLDER_GROUP = 2;
    private static final int AFTER_KEY_PLACEHOLDER_GROUP = 3;

    private DiffMerger() {
    }

    public static <T> T mergeDiffs(@Nonnull T object, Collection<DataDiff<?>> diffs) {
        HashMap<String, Set<Object>> prev;
        Set<DataDiff> skipped = new HashSet<DataDiff>(diffs);
        Map<String, Set<Object>> refsDict = new HashMap<String, Set<Object>>();
        do {
            prev = refsDict;
            skipped = DiffMerger.internalApplyDiffs(refsDict, object.getClass(), object, skipped);
            if (skipped.size() <= 0) continue;
            refsDict = DiffMerger.initReferencesDictIfNeeded(object);
        } while (skipped.size() > 0 && !prev.keySet().containsAll(refsDict.keySet()));
        if (skipped.size() > 0) {
            throw new IllegalArgumentException("Reference rules weren't found. " + skipped);
        }
        return object;
    }

    private static <T> Map<String, Set<Object>> initReferencesDictIfNeeded(T object) {
        return FieldUtils.getFieldsListWithAnnotation(object.getClass(), DiffReferenceable.class).stream().map(DiffUtils::fieldToMethod).map(method -> (Pair)ExceptionUtils.wrapException(() -> Pair.of((Object)method, (Object)method.invoke(object, new Object[0])), IllegalStateException.class)).flatMap(pair -> {
            Object listOrMap = pair.getRight();
            if (listOrMap instanceof Map) {
                return ((Map)listOrMap).entrySet().stream().map(entry -> Pair.of((Object)entry.getKey().toString(), entry.getValue()));
            }
            if (listOrMap instanceof Collection) {
                Type[] genericTypes = ((ParameterizedType)((Method)pair.getLeft()).getGenericReturnType()).getActualTypeArguments();
                Method keyMethod = DiffMerger.findKeyMethod(DiffMerger.findParameterType(genericTypes[0]));
                return ((List)listOrMap).stream().map(entry -> (Pair)ExceptionUtils.wrapException(() -> Pair.of((Object)("" + keyMethod.invoke(entry, new Object[0])), (Object)entry), IllegalStateException.class));
            }
            throw new IllegalStateException(DiffReferenceable.class.getSimpleName() + " must be over list or map return type");
        }).collect(Collectors.toMap(Pair::getLeft, pair -> ImmutableSet.of((Object)pair.getRight()), DiffMerger::combineSets));
    }

    private static <T> Set<DataDiff> internalApplyDiffs(Map<String, Set<Object>> refsDict, Class<?> clazz, T object, Collection<DataDiff> diffs) {
        Class<?> impl = DiffMerger.findImpl(clazz);
        Map<String, Set<DataDiff>> fieldNameToDiff = DiffUtils.diffForField(diffs, DataDiff::getFieldName);
        Map<String, Set<DataDiff>> firstLevel = DiffMerger.compressFieldsToFirstLevel(fieldNameToDiff);
        Method[] allMethods = impl.getMethods();
        return firstLevel.entrySet().stream().flatMap(entry -> {
            if (DiffMerger.assertValidKeyAndObject(object, entry)) {
                return Stream.of(new DataDiff[0]);
            }
            Method getter = DiffMerger.findGetter(allMethods, (String)entry.getKey());
            return DiffMerger.processChild(refsDict, impl, object, (String)entry.getKey(), (Set)entry.getValue(), allMethods, getter, DiffUtils.methodToField(getter)).stream();
        }).map(newData -> new DataDiff((StringUtils.isEmpty((CharSequence)newData.getPrefixContext()) ? "" : newData.getPrefixContext() + "\u00bb") + newData.getFieldName(), newData.getNewValue())).collect(Collectors.toSet());
    }

    private static <T> boolean assertValidKeyAndObject(T object, Map.Entry<String, Set<DataDiff>> entry) {
        if (StringUtils.isEmpty((CharSequence)entry.getKey())) {
            throw new IllegalArgumentException("Key must not be empty");
        }
        if (object == null) {
            throw new IllegalStateException("Object for key " + entry.getKey() + " is empty");
        }
        return entry.getKey().equals("$$new");
    }

    private static Class<?> findImpl(Class<?> clazz) {
        if (clazz.getAnnotation(GenerateDiffFunction.class) == null) {
            throw new IllegalStateException("Class " + clazz.getName() + " must be annotated with " + GenerateDiffFunction.class.getSimpleName());
        }
        Class<?> impl = clazz;
        Class<?> defaultImpl = clazz.getAnnotation(GenerateDiffFunction.class).defaultImpl();
        if (ClassUtils.isAssignable(defaultImpl, clazz)) {
            impl = defaultImpl;
        }
        return impl;
    }

    private static <T> Set<DataDiff> processChild(Map<String, Set<Object>> refsDict, Class clazz, T object, String key, Set<DataDiff> value, Method[] allMethods, Method getter, Field field) {
        boolean isReference;
        Class<?> param = getter.getReturnType();
        Set<DataDiff> referencedValue = value;
        boolean bl = isReference = field.getAnnotation(DiffReference.class) != null;
        if (isReference && (referencedValue = DiffMerger.parseReference(refsDict, value, getter.getGenericReturnType())).isEmpty()) {
            return value;
        }
        if (isReference || DiffMerger.isPrimitiveOrWrapperOrAtomic(param, field) || DiffMerger.isDeletedLeaf(referencedValue, key)) {
            Method setter = DiffMerger.findSetter(allMethods, key);
            DiffMerger.handlePrimitive(refsDict, referencedValue, diff -> DiffMerger.invokeSetter(object, diff.getNewValue(), setter), clazz.getSimpleName() + "#" + setter.getName(), setter.getParameterTypes()[0], setter, isReference);
            return ImmutableSet.of();
        }
        if (ClassUtils.isAssignable(param, Map.class) || ClassUtils.isAssignable(param, Collection.class)) {
            return DiffMerger.handleMapOrCollection(refsDict, allMethods, object, referencedValue, getter, param, key);
        }
        String signature = object.getClass().getSimpleName() + "#" + getter.getName();
        Object childObject = ExceptionUtils.wrapException(() -> getter.invoke(object, new Object[0]), IllegalStateException.class, null, (String)signature);
        if (childObject == null) {
            Method setter = DiffMerger.findSetter(allMethods, key);
            Object newChildObject = DiffMerger.initObjectForType(setter.getParameterTypes()[0], key);
            ExceptionUtils.wrapException(() -> setter.invoke(object, newChildObject), IllegalStateException.class);
            childObject = ExceptionUtils.wrapException(() -> getter.invoke(object, new Object[0]), IllegalStateException.class, null, (String)signature);
        }
        return DiffMerger.internalApplyDiffs(refsDict, param, childObject, referencedValue.stream().map(diff -> new DataDiff(key, DiffMerger.removeFieldPrefix(diff, key), diff.getOldValue(), diff.getNewValue())).collect(Collectors.toSet()));
    }

    private static boolean isDeletedLeaf(Set<DataDiff> referencedValue, String key) {
        if (referencedValue.size() != 1) {
            return false;
        }
        DataDiff next = referencedValue.iterator().next();
        return next.getNewValue() == null && "$$deleted".equals(DiffMerger.removeFieldPrefix(next, key));
    }

    private static Set<DataDiff> parseReference(Map<String, Set<Object>> refsDict, Set<DataDiff> value, Type param) {
        Set<DataDiff> referencedValue = value.stream().map(data -> Pair.of((Object)data, new DataDiff<Object>(data.getPrefixContext(), data.getFieldName(), data.getOldValue(), DiffMerger.refValueForObjectOrCollection(refsDict, data, param)))).filter(oldAndNewData -> ((DataDiff)oldAndNewData.getLeft()).getNewValue() == null || ((DataDiff)oldAndNewData.getRight()).getNewValue() != null && (!(((DataDiff)oldAndNewData.getRight()).getNewValue() instanceof Collection) || !((Collection)((DataDiff)oldAndNewData.getRight()).getNewValue()).isEmpty())).map(Pair::getRight).collect(Collectors.toSet());
        return referencedValue;
    }

    private static Object refValueForObjectOrCollection(Map<String, Set<Object>> refsDict, DataDiff<Object> data, Type param) {
        if (data.getNewValue() instanceof Collection) {
            List list = ((Collection)data.getNewValue()).stream().map(val -> DiffMerger.refValueForObject(refsDict, val, DiffMerger.findParameterType(((ParameterizedType)param).getActualTypeArguments()[0]))).filter(Objects::nonNull).collect(Collectors.toList());
            return data.getNewValue() instanceof Set ? new TreeSet(list) : list;
        }
        if (TypeUtils.isAssignable((Type)param, Collection.class)) {
            return DiffMerger.refValueForObject(refsDict, data.getNewValue(), DiffMerger.findParameterType(((ParameterizedType)param).getActualTypeArguments()[0]));
        }
        return DiffMerger.refValueForObject(refsDict, data.getNewValue(), (Class)param);
    }

    private static Object refValueForObject(Map<String, Set<Object>> refsDict, Object data, Class<?> param) {
        return ((Set)refsDict.getOrDefault(data, new HashSet())).stream().filter(referenced -> ClassUtils.isAssignable(referenced.getClass(), (Class)param)).findFirst().orElse(null);
    }

    private static Method findGetter(Method[] allMethods, String key) {
        String getterName = "get" + StringUtils.capitalize((String)key);
        String isserName = "is" + StringUtils.capitalize((String)key);
        return Stream.of(allMethods).filter(method -> {
            Field field;
            try {
                field = DiffUtils.methodToField(method);
            }
            catch (IllegalStateException e) {
                return false;
            }
            return DiffMerger.getterDelegatedName(field, method, getterName, key) || DiffMerger.getterDelegatedName(field, method, isserName, key);
        }).filter(method -> method.getParameterCount() == 0).min(Comparator.comparingInt(DiffMerger::booleanToInt)).orElseThrow(() -> new IllegalArgumentException("Key \"" + key + "\" is not part of the configuration"));
    }

    private static int booleanToInt(Method first) {
        return first.getReturnType().isInterface() ? 1 : -1;
    }

    public static Method findSetter(Method[] allMethods, String key) {
        Method setter = DiffMerger.optionallyFindSetter(allMethods, key).orElseThrow(() -> new IllegalArgumentException("Key " + key + " is not changeable"));
        if (setter.getParameterCount() != 1) {
            throw new IllegalStateException("Parameter count for " + setter.getDeclaringClass().getName() + "#" + setter.getName() + " must be 1");
        }
        return setter;
    }

    private static Optional<Method> optionallyFindSetter(Method[] allMethods, String key) {
        Method getter = DiffMerger.findGetter(allMethods, key);
        String setterName = "set" + StringUtils.capitalize((String)DiffUtils.toFieldName(getter.getName()));
        return Stream.of(allMethods).filter(method -> setterName.equals(method.getName())).findFirst();
    }

    private static boolean getterDelegatedName(Field field, Method method, String methodExpected, String key) {
        DiffElement mergeAnnon = field.getAnnotation(DiffElement.class);
        return mergeAnnon != null && !StringUtils.isEmpty((CharSequence)mergeAnnon.name()) && key.equals(mergeAnnon.name()) || methodExpected.equals(method.getName());
    }

    public static boolean isPrimitiveOrWrapperOrAtomic(Class<?> param, Field field) {
        return ClassUtils.isPrimitiveOrWrapper(param) || ClassUtils.isAssignable(param, String.class) || ClassUtils.isAssignable(param, File.class) || ClassUtils.isAssignable(param, Enum.class) || field != null && field.isAnnotationPresent(DiffAtomic.class) || field != null && DiffMerger.isCollectionOrMapOfPrimitive(field);
    }

    private static boolean isCollectionOrMapOfPrimitive(Field field) {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            return false;
        }
        Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        if (ClassUtils.isAssignable(field.getType(), Map.class) && types[1] instanceof Class) {
            return DiffMerger.isPrimitiveOrWrapperOrAtomic((Class)types[1], null);
        }
        return ClassUtils.isAssignable(field.getType(), Collection.class) && types[0] instanceof Class && DiffMerger.isPrimitiveOrWrapperOrAtomic((Class)types[0], null);
    }

    private static <T> Set<DataDiff> handleMapOrCollection(Map<String, Set<Object>> refsDict, Method[] allMethods, T mainObject, Set<DataDiff> value, Method getter, Class<?> param, String key) {
        Map map;
        Collection collection;
        Class<?> parameterType;
        Object childObject = ExceptionUtils.wrapException(() -> getter.invoke(mainObject, new Object[0]));
        Type[] genericTypes = ((ParameterizedType)getter.getGenericReturnType()).getActualTypeArguments();
        boolean isCollection = ClassUtils.isAssignable(param, Collection.class);
        if (isCollection) {
            parameterType = DiffMerger.findParameterType(genericTypes[0]);
            Function<Object, String> keyMethodInvoker = DiffMerger.invokeKeyMethod(parameterType);
            collection = (Collection)childObject;
            map = collection.stream().collect(Collectors.toMap(keyMethodInvoker, Function.identity()));
        } else {
            parameterType = DiffMerger.findParameterType(genericTypes[1]);
            map = (Map)childObject;
            collection = null;
        }
        Set<DataDiff> toSkip = DiffMerger.processMapOrCollectionElements(refsDict, key, value, parameterType, map, collection);
        DiffMerger.optionallyFindSetter(allMethods, key).ifPresent(method -> DiffMerger.invokeSetter(mainObject, isCollection ? collection : map, method));
        return toSkip;
    }

    public static Class<?> findParameterType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof WildcardType) {
            return DiffMerger.findParameterType(((WildcardType)genericType).getUpperBounds()[0]);
        }
        throw new IllegalStateException("Unsupported type of generic: " + genericType);
    }

    public static Function<Object, String> invokeKeyMethod(Class<?> parameterType) {
        return object -> (String)ExceptionUtils.wrapException(() -> "" + DiffMerger.findKeyMethod(parameterType).invoke(object, new Object[0]), IllegalStateException.class);
    }

    public static Method findKeyMethod(Class<?> parameterType) {
        return DiffUtils.fieldToMethod(DiffMerger.findKeyField(parameterType));
    }

    private static Field findKeyField(Class<?> parameterType) {
        return DiffMerger.allFields(parameterType).stream().filter(field -> field.getAnnotation(DiffKey.class) != null).findFirst().orElseThrow(() -> new IllegalStateException(DiffKey.class.getSimpleName() + " is not present on any method on " + parameterType.getName()));
    }

    public static Set<Field> allFields(Class<?> clazz) {
        return ImmutableSet.builder().addAll(Arrays.asList(clazz.getDeclaredFields())).addAll(Object.class.equals(clazz.getSuperclass()) ? Collections.emptyList() : DiffMerger.allFields(clazz.getSuperclass())).build();
    }

    private static Set<DataDiff> processMapOrCollectionElements(Map<String, Set<Object>> refsDict, String key, Set<DataDiff> value, Class<?> parameterType, Map map, Collection collection) {
        HashMap complexes = new HashMap();
        Set<DataDiff> skipped = DiffMerger.replaceKeysPlaceholders(key, value, parameterType).stream().flatMap(diff -> {
            String[] splitted = diff.getFieldName().split("[\u00bb]");
            if (splitted.length == 1) {
                throw new IllegalArgumentException(parameterType.getSimpleName() + " is a collection of data and provided data is for single data point");
            }
            if (StringUtils.isEmpty((CharSequence)splitted[1])) {
                throw new IllegalArgumentException("Key must not be empty");
            }
            if (DiffMerger.processSpecialInstructionsForMap(map, collection, diff, splitted)) {
                return Stream.empty();
            }
            if (ClassUtils.isPrimitiveOrWrapper((Class)parameterType)) {
                return DiffMerger.handlePrimitive(refsDict, (Set<DataDiff>)ImmutableSet.of((Object)diff), d -> DiffMerger.handlePrimitiveForMapOrCollection(map, collection, diff, splitted[1]), diff.getFieldName(), parameterType, null, false).stream();
            }
            String prefix = splitted[0] + "\u00bb" + splitted[1];
            String keyField = DiffUtils.toFieldName(DiffMerger.findKeyMethod(parameterType).getName());
            DataDiff<String> keyNewData = new DataDiff<String>(prefix, keyField, null, splitted[1]);
            complexes.computeIfAbsent(splitted[1], x -> new HashSet()).add(new DataDiff(prefix, DiffMerger.removeFieldPrefix(diff, prefix), diff.getOldValue(), diff.getNewValue()));
            ((Set)complexes.get(splitted[1])).add(keyNewData);
            return Stream.empty();
        }).collect(Collectors.toSet());
        if (!skipped.isEmpty()) {
            return skipped;
        }
        return complexes.entrySet().stream().peek(entry -> DiffMerger.putIfAbsent(parameterType, map, collection, (String)entry.getKey())).flatMap(entry -> DiffMerger.internalApplyDiffs(refsDict, parameterType, map.get(entry.getKey()), (Collection)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    private static void putIfAbsent(Class<?> parameterType, Map map, Collection collection, String key) {
        if (!map.containsKey(key)) {
            Object newInstance = DiffMerger.initObjectForType(parameterType, key);
            if (collection != null) {
                collection.add(newInstance);
            }
            map.put(key, newInstance);
        }
    }

    private static Object initObjectForType(Class<?> parameterType, String key) {
        Object newInstance;
        Class<?> impl = DiffMerger.findImpl(parameterType);
        try {
            newInstance = impl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not create " + impl.getSimpleName() + " for key " + key);
        }
        return newInstance;
    }

    private static Set<DataDiff> replaceKeysPlaceholders(String key, Set<DataDiff> value, Class<?> parameterType) {
        String keyPropertyName = DiffUtils.toFieldName(DiffMerger.findKeyMethod(parameterType).getName());
        Map<String, Object> keyDict = value.stream().map(elem -> Pair.of((Object)elem, (Object)KEY_PLACEHOLDER_REGEX.matcher(elem.getFieldName()))).filter(pair -> DiffMerger.matches((Matcher)pair.getRight(), key)).filter(pair -> ((Matcher)pair.getRight()).group(3).equals(keyPropertyName)).map(pair -> Pair.of((Object)pair.getLeft(), (Object)((Matcher)pair.getRight()).group(2))).collect(Collectors.toMap(Pair::getRight, pair -> ((DataDiff)pair.getLeft()).getNewValue()));
        if (keyDict.values().stream().distinct().count() < (long)keyDict.size()) {
            throw new IllegalArgumentException("Multiple not distinct keys for " + key);
        }
        return value.stream().map(elem -> {
            Matcher matcher = KEY_PLACEHOLDER_REGEX.matcher(elem.getFieldName());
            if (DiffMerger.matches(matcher, key)) {
                return new DataDiff(matcher.group(1) + "\u00bb" + matcher.group(2), matcher.group(1) + "\u00bb" + keyDict.get(matcher.group(2)) + "\u00bb" + matcher.group(3), elem.getOldValue(), elem.getNewValue());
            }
            return elem;
        }).collect(Collectors.toSet());
    }

    private static boolean matches(Matcher matcher, String key) {
        return matcher.matches() && matcher.group(1).equals(key);
    }

    private static void handlePrimitiveForMapOrCollection(Map map, Collection collection, DataDiff diff, String key) {
        if (collection != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                int indexOf = list.indexOf(map.get(key));
                if (indexOf < 0) {
                    list.add(diff.getNewValue());
                    return;
                }
                list.set(list.indexOf(map.get(key)), diff.getNewValue());
                return;
            }
            throw new IllegalStateException("Auto merge of " + collection.getClass().getSimpleName() + " is not supported");
        }
        map.put(key, diff.getNewValue());
    }

    private static boolean processSpecialInstructionsForMap(Map map, Collection collection, DataDiff diff, String[] splitted) {
        if (splitted.length == 3) {
            if (splitted[2].equals("$$new")) {
                if (collection != null) {
                    if (map.containsKey(splitted[1])) {
                        collection.remove(map.get(splitted[1]));
                    }
                    collection.add(diff.getNewValue());
                } else {
                    map.put(splitted[1], diff.getNewValue());
                }
                return true;
            }
            if (splitted[2].equals("$$deleted")) {
                if (collection != null) {
                    collection.remove(map.get(splitted[1]));
                } else {
                    map.remove(splitted[1]);
                }
                return true;
            }
        }
        return false;
    }

    private static Set<DataDiff> handlePrimitive(Map<String, Set<Object>> refsDict, Set<DataDiff> value, Consumer<DataDiff<?>> invoke, String signature, Class<?> type, Method setter, boolean isReferenced) {
        if (setter != null && ClassUtils.isAssignable(type, Collection.class) && (value.stream().allMatch(data -> StringUtils.countMatches((CharSequence)data.getFieldName(), (CharSequence)"\u00bb") >= 2) || value.stream().allMatch(data -> KEY_PLACEHOLDER_REGEX.matcher(data.getFieldName()).matches()))) {
            try {
                Type collectionType = ((ParameterizedType)setter.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
                Set<DataDiff> toProcess = isReferenced ? value : DiffMerger.newInstanceForEntities(refsDict, value, signature, DiffMerger.findParameterType(collectionType));
                DiffMerger.extractPrimitiveCollection(type, toProcess, signature).ifPresent(invoke);
            }
            catch (SkippedException e) {
                return e.data;
            }
            return Collections.emptySet();
        }
        if (value.size() != 1) {
            throw new IllegalArgumentException("Number of diffs count for primitive must be 1 [" + signature + "] " + value);
        }
        value.stream().map(v -> DiffMerger.convertPrimitive(type, v)).forEach(invoke);
        return Collections.emptySet();
    }

    public static List<DataDiff<?>> diffToDataDiff(List<Diff<?>> diffs) {
        return diffs.stream().map(currDiff -> new DataDiff<Object>(currDiff.getFieldName(), currDiff.getLeft(), currDiff.getRight())).collect(Collectors.toList());
    }

    private static Set<DataDiff> newInstanceForEntities(Map<String, Set<Object>> refsDict, Set<DataDiff> value, String signature, Class<?> entitiesType) {
        if (DiffMerger.isPrimitiveOrWrapperOrAtomic(entitiesType, null)) {
            return value.stream().map(diff -> new DataDiff<Object>(diff.getPrefixContext(), diff.getFieldName(), diff.getOldValue(), DiffMerger.findValueToSet(diff.getNewValue(), entitiesType))).collect(Collectors.toSet());
        }
        Map<String, Set> data = value.stream().map(DiffMerger::fieldKeyToEntity).collect(Collectors.toMap(Pair::getLeft, pair -> ImmutableSet.of((Object)pair.getRight()), DiffMerger::combineSets));
        return data.entrySet().stream().map(perEntity -> DiffMerger.newObjectForEntity(refsDict, perEntity, entitiesType, signature)).collect(Collectors.toSet());
    }

    private static Pair<String, DataDiff<Object>> fieldKeyToEntity(DataDiff entity) {
        String key;
        Matcher matcher = KEY_PLACEHOLDER_REGEX.matcher(entity.getFieldName());
        if (matcher.matches()) {
            key = matcher.group(1) + "\u00bb" + String.format(KEY_PLACEHOLDER_FORMAT, Integer.parseInt(matcher.group(2)));
        } else {
            String[] split = entity.getFieldName().split("\u00bb", 3);
            if (split.length != 3) {
                throw new IllegalStateException("Unexpected field name format " + entity.getFieldName());
            }
            key = split[0] + "\u00bb" + split[1];
        }
        return Pair.of((Object)key, new DataDiff(key, DiffMerger.removeFieldPrefix(entity, key), entity.getOldValue(), entity.getNewValue()));
    }

    private static DataDiff<Object> newObjectForEntity(Map<String, Set<Object>> refsDict, Map.Entry<String, Set<DataDiff>> perEntity, Class<?> entitiesType, String signature) {
        Set<DataDiff> skipped;
        DataDiff first = perEntity.getValue().iterator().next();
        Object newObject = DiffMerger.initObjectForType(entitiesType, signature);
        String[] splitted = first.getPrefixContext().split("\u00bb");
        if (splitted.length == 2 && !splitted[1].matches(KEY_PLACEHOLDER_FORMAT_REGEX)) {
            DiffMerger.invokeSetter(newObject, splitted[1], DiffMerger.findSetter(entitiesType.getMethods(), DiffMerger.findKeyField(entitiesType).getName()));
        }
        if (!(skipped = DiffMerger.internalApplyDiffs(refsDict, entitiesType, newObject, (Collection<DataDiff>)perEntity.getValue())).isEmpty()) {
            throw new SkippedException(skipped);
        }
        return new DataDiff<Object>(first.getPrefixContext(), perEntity.getKey(), null, newObject);
    }

    private static DataDiff<?> convertPrimitive(Class<?> type, DataDiff<?> v) {
        if (ClassUtils.isPrimitiveOrWrapper(type)) {
            try {
                if (v.getNewValue() == null && ClassUtils.isPrimitiveWrapper(type)) {
                    return v;
                }
                return new DataDiff<Object>(v.getPrefixContext(), v.getFieldName(), v.getOldValue(), ConvertUtils.convert(v.getNewValue(), type));
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return v;
    }

    private static Optional<DataDiff<Collection>> extractPrimitiveCollection(Class<?> type, Set<DataDiff> value, String signature) {
        List<Pair<String, Object>> data = value.stream().allMatch(prop -> KEY_PLACEHOLDER_REGEX.matcher(prop.getFieldName()).matches()) ? DiffMerger.extractKeyPlaceholderFromRegex(value, signature) : DiffMerger.extractKeyPlaceholderFromConcrete(value);
        if (!data.isEmpty()) {
            String fieldName = (String)data.get(0).getLeft();
            TreeSet primitiveCollection = (TreeSet)((Object)data.stream().peek(entity -> {
                if (!fieldName.equals(entity.getLeft())) {
                    throw new IllegalStateException("Illegal data for " + signature + ". data: " + value);
                }
            }).map(Pair::getRight).collect(Collectors.toList()));
            if (ClassUtils.isAssignable(type, Set.class)) {
                primitiveCollection = new TreeSet(primitiveCollection);
            }
            return Optional.of(new DataDiff(fieldName, primitiveCollection));
        }
        return Optional.empty();
    }

    private static List<Pair<String, Object>> extractKeyPlaceholderFromConcrete(Set<DataDiff> value) {
        return value.stream().map(entity -> Pair.of((Object)entity.getFieldName(), entity.getNewValue())).collect(Collectors.toList());
    }

    private static List<Pair<String, Object>> extractKeyPlaceholderFromRegex(Set<DataDiff> value, String signature) {
        return ((Stream)value.stream().map(entity -> {
            Matcher matcher = KEY_PLACEHOLDER_REGEX.matcher(entity.getFieldName());
            if (matcher.matches() && matcher.group(3).isEmpty()) {
                return Triple.of((Object)matcher.group(1), (Object)Integer.parseInt(matcher.group(2)), entity.getNewValue());
            }
            throw new IllegalStateException(signature + " must be in format fieldname.{position}");
        }).sequential()).sorted(Comparator.comparingInt(Triple::getMiddle)).map(triple -> Pair.of((Object)triple.getLeft(), (Object)triple.getRight())).collect(Collectors.toList());
    }

    private static <T> void invokeSetter(T object, Object value, Method setter) {
        try {
            Object valueToSet = DiffMerger.findValueToSet(value, setter.getParameterTypes()[0]);
            setter.invoke(object, valueToSet);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot invoke " + setter.getDeclaringClass().getName() + "#" + setter.getName(), e);
        }
    }

    private static Object findValueToSet(Object value, Class<?> param) {
        if (param.isEnum() && ClassUtils.isAssignable(value.getClass(), String.class)) {
            return DiffMerger.findEnum(param, (String)value);
        }
        return value;
    }

    private static Object findEnum(Class<?> enumClass, String name) {
        Method typeMethod;
        GenerateDiffFunction annotation = enumClass.getAnnotation(GenerateDiffFunction.class);
        if (annotation == null) {
            throw new IllegalStateException("Enum class is not implementing " + GenerateDiffFunction.class.getSimpleName());
        }
        try {
            typeMethod = enumClass.getMethod(annotation.typeMethod(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Method " + annotation.typeMethod() + " that was referred as typeMethod was not found in " + enumClass.getSimpleName());
        }
        return Stream.of(enumClass.getEnumConstants()).filter(enValue -> ExceptionUtils.wrapException(() -> typeMethod.invoke(enValue, new Object[0])).equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException(enumClass.getSimpleName() + ": Enum constant wasn't found for " + name));
    }

    private static Map<String, Set<DataDiff>> compressFieldsToFirstLevel(Map<String, Set<DataDiff>> allDiffs) {
        return allDiffs.entrySet().stream().collect(Collectors.toMap(entry -> DiffMerger.findParentKey((String)entry.getKey()), entry -> ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), DiffMerger::combineSets));
    }

    private static <U> Set<U> combineSets(Set<U> set1, Set<U> set2) {
        return ImmutableSet.builder().addAll(set1).addAll(set2).build();
    }

    private static String findParentKey(String key) {
        if (!key.contains("\u00bb")) {
            return key;
        }
        return key.substring(0, key.indexOf("\u00bb"));
    }

    private static String removeFieldPrefix(DataDiff other, String prefix) {
        return other.getFieldName().replaceFirst("^" + Pattern.quote(prefix + "\u00bb"), "");
    }

    private static class SkippedException
    extends RuntimeException {
        final Set<DataDiff> data;

        SkippedException(Set<DataDiff> data) {
            this.data = data;
        }
    }
}

