package org.jfrog.common.config.diff;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Mark a collection of fields as referenceable, which means other beans can mark a field as reference to one of the
 * elements in the collection.
 *
 * The diff engine will try to resolve the reference in several iterations when sees a @{@link DiffReference}.
 * If it fails to find a suitable element in all the other @{@link DiffReferenceable}s it raises an exception.
 *
 * @author Noam Shemesh
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DiffReferenceable {
}
