package org.jfrog.common.config.diff;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Atomic field, which is marked by using this annotation, is a field that doesn't breakdown to smaller pieces while
 * comparing differences between two parent entities.
 * In other words, atomic fields are compared just like any other primitive type (e.g. Integer)
 *
 * @author Noam Shemesh
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DiffAtomic {
}
