package org.jfrog.common.config.diff;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * @author Noam Shemesh
 */
public class DataDiff<T> {
    private final String prefixContext;
    private final String fieldName;
    private final T newValue;
    private final T oldValue;

    public DataDiff(String fieldName, T oldValue, T newValue) {
        this("", fieldName, oldValue, newValue);
    }

    public DataDiff(String fieldName, T newValue) {
        this(fieldName, (T) null, newValue);
    }

    @JsonCreator
    public DataDiff(String prefixContext, String fieldName, T oldValue, T newValue) {
        this.fieldName = fieldName;
        this.prefixContext = prefixContext;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getFieldName() {
        return fieldName;
    }

    public T getNewValue() {
        return newValue;
    }

    public T getOldValue() {
        return oldValue;
    }

    String getPrefixContext() {
        return prefixContext;
    }

    @Override
    public String toString() {
        return fieldName + '=' + newValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DataDiff<?> dataDiff = (DataDiff<?>) o;

        if (fieldName != null ? !fieldName.equals(dataDiff.fieldName) : dataDiff.fieldName != null) {
            return false;
        }
        if (newValue != null ? !newValue.equals(dataDiff.newValue) : dataDiff.newValue != null) {
            return false;
        }
        if (oldValue != null ? !oldValue.equals(dataDiff.oldValue) : dataDiff.oldValue != null) {
            return false;
        }
        return prefixContext != null ? prefixContext.equals(dataDiff.prefixContext) : dataDiff.prefixContext == null;
    }

    @Override
    public int hashCode() {
        int result = fieldName != null ? fieldName.hashCode() : 0;
        result = 31 * result + (newValue != null ? newValue.hashCode() : 0);
        result = 31 * result + (oldValue != null ? oldValue.hashCode() : 0);
        result = 31 * result + (prefixContext != null ? prefixContext.hashCode() : 0);
        return result;
    }
}
