/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.docker.extractor;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.multiMap.ListMultimap;
import org.jfrog.build.api.multiMap.Multimap;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.docker.DockerJavaWrapper;
import org.jfrog.build.extractor.docker.DockerUtils;
import org.jfrog.build.extractor.docker.extractor.DockerCommand;
import org.jfrog.build.extractor.docker.types.DockerImage;
import org.jfrog.build.extractor.docker.types.DockerLayer;
import org.jfrog.build.extractor.docker.types.DockerLayers;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class DockerPush
extends DockerCommand {
    private final Multimap<String, String> artifactProperties;

    public DockerPush(ArtifactoryManagerBuilder artifactoryManagerBuilder, String imageTag, String host, Multimap<String, String> artifactProperties, String targetRepository, String username, String password, Log logger, Map<String, String> env) {
        super(artifactoryManagerBuilder, imageTag, host, targetRepository, username, password, logger, env);
        this.artifactProperties = artifactProperties;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.publisher);
            ArtifactoryClientConfiguration.DockerHandler dockerHandler = clientConfiguration.dockerHandler;
            DockerPush dockerPush = new DockerPush(artifactoryManagerBuilder, dockerHandler.getImageTag(), dockerHandler.getHost(), (Multimap<String, String>)new ListMultimap(clientConfiguration.publisher.getMatrixParams()), clientConfiguration.publisher.getRepoKey(), clientConfiguration.publisher.getUsername(), clientConfiguration.publisher.getPassword(), clientConfiguration.getLog(), clientConfiguration.getAllProperties());
            dockerPush.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    public BuildInfo execute() {
        String message = "Pushing image: " + this.imageTag;
        if (StringUtils.isNotEmpty((CharSequence)this.host)) {
            message = message + " using docker daemon host: " + this.host;
        }
        this.logger.info(message);
        try {
            DockerJavaWrapper.pushImage(this.imageTag, this.username, this.password, this.host, this.env, this.logger);
            String imageId = DockerJavaWrapper.getImageIdFromTag(this.imageTag, this.host, this.env, this.logger);
            DockerImage image = new DockerImage(imageId, this.imageTag, "", this.targetRepository, this.artifactoryManagerBuilder, "", "");
            Module module = image.generateBuildInfoModule(this.logger, DockerUtils.CommandType.Push);
            if (module.getArtifacts() == null || module.getArtifacts().isEmpty()) {
                this.logger.warn("Could not find docker image: " + this.imageTag + " in Artifactory.");
            } else {
                this.setImageLayersProps(image.getLayers(), this.artifactProperties, this.artifactoryManagerBuilder);
            }
            BuildInfo buildInfo = new BuildInfo();
            this.modulesList.add(module);
            buildInfo.setModules(this.modulesList);
            this.logger.info("Successfully pushed docker image: " + this.imageTag);
            return buildInfo;
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void setImageLayersProps(DockerLayers layers, Multimap<String, String> artifactProperties, ArtifactoryManagerBuilder artifactoryManagerBuilder) throws IOException {
        if (layers == null) {
            return;
        }
        try (ArtifactoryManager artifactoryManager = artifactoryManagerBuilder.build();){
            for (DockerLayer layer : layers.getLayers()) {
                artifactoryManager.setProperties(layer.getFullPath(), artifactProperties, true);
            }
        }
    }
}

