/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.multiMap;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jfrog.build.api.multiMap.ListMultimap;
import org.jfrog.build.api.multiMap.SetMultimap;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ListMultimap.class, name="list"), @JsonSubTypes.Type(value=SetMultimap.class, name="set")})
public abstract class Multimap<Key, Value>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<Key, Collection<Value>> multiMap = new HashMap<Key, Collection<Value>>();

    Multimap() {
    }

    Multimap(Map<Key, Value> map) {
        map.forEach(this::put);
    }

    public abstract void put(Key var1, Value var2);

    public Collection<Value> get(Key key) {
        return this.multiMap.get(key);
    }

    public void putAll(Map<Key, Value> map) {
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Multimap<Key, Value> multimap) {
        for (Map.Entry<Key, Collection<Value>> entry : multimap.multiMap.entrySet()) {
            for (Value value : entry.getValue()) {
                this.put(entry.getKey(), value);
            }
        }
    }

    public void putAll(Key key, Collection<Value> values) {
        for (Value value : values) {
            this.put(key, value);
        }
    }

    public Set<Map.Entry<Key, Value>> entries() {
        HashSet<Map.Entry<Key, Value>> entries = new HashSet<Map.Entry<Key, Value>>();
        for (Map.Entry<Key, Collection<Value>> entry : this.multiMap.entrySet()) {
            for (Value value : entry.getValue()) {
                entries.add(new AbstractMap.SimpleEntry<Key, Value>(entry.getKey(), value));
            }
        }
        return entries;
    }

    public Map<Key, Collection<Value>> asMap() {
        return this.multiMap;
    }

    public Set<Key> keySet() {
        return this.multiMap.keySet();
    }

    public boolean containsValue(Value value) {
        for (Collection<Value> values : this.multiMap.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        for (Collection<Value> values : this.multiMap.values()) {
            size += values.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.multiMap.isEmpty();
    }

    public void clear() {
        this.multiMap.clear();
    }
}

